% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-helpers.R
\name{cs}
\alias{cs}
\alias{cse}
\title{Category Specific Predictors in \pkg{brms} Models}
\usage{
cs(expr)
}
\arguments{
\item{expr}{Expression containing predictors,
for which category specific effects should
be estimated. For evaluation, \R formula syntax is applied.}
}
\description{
Category Specific Predictors in \pkg{brms} Models
}
\details{
For detailed documentation see \code{help(brmsformula)}
  as well as \code{vignette("brms_overview")}.

This function is almost solely useful when
called in formulas passed to the \pkg{brms} package.
}
\examples{
  
\dontrun{
fit <- brm(rating ~ period + carry + cs(treat), 
           data = inhaler, family = sratio("cloglog"), 
           prior = set_prior("normal(0,5)"), chains = 2)
summary(fit)
plot(fit, ask = FALSE)
} 
 
}
\seealso{
\code{\link[brms:brmsformula]{brmsformula}}
}
