% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstanarm_tidiers.R
\name{rstanarm_tidiers}
\alias{glance.stanreg}
\alias{rstanarm_tidiers}
\alias{tidy.stanreg}
\title{Tidying methods for an rstanarm model}
\usage{
\method{tidy}{stanreg}(x, parameters = c("non-varying", "varying",
  "hierarchical"), intervals = FALSE, prob = 0.9, ...)

\method{glance}{stanreg}(x, looic = FALSE, ...)
}
\arguments{
\item{x}{Fitted model object from the \pkg{rstanarm} package. See 
\code{\link[rstanarm]{stanreg-objects}}.}

\item{parameters}{One of \code{"non-varying"}, \code{"varying"}, or 
\code{"hierarchical"} (can be abbreviated). See the Value section for 
details.}

\item{intervals}{If \code{TRUE} columns for the lower and upper bounds of the
\code{100*prob}\% posterior uncertainty intervals are included. See 
\code{\link[rstanarm]{posterior_interval}} for details.}

\item{prob}{See \code{\link[rstanarm]{posterior_interval}}.}

\item{...}{For \code{glance}, if \code{looic=TRUE}, optional arguments to
\code{\link[rstanarm]{loo.stanreg}}.}

\item{looic}{Should the LOO Information Criterion be included? See 
\code{\link[rstanarm]{loo.stanreg}} for details. Note: for models fit to
very large data this can be a slow computation.}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

When \code{parameters="non-varying"} (the default), \code{tidy.stanreg} returns
one row for each coefficient, with three columns:
\item{term}{The name of the corresponding term in the model.}
\item{estimate}{A point estimate of the coefficient (posterior median).}
\item{std.error}{A standard error for the point estimate based on
\code{\link[stats]{mad}}. See the \emph{Uncertainty estimates} section in 
\code{\link[rstanarm]{print.stanreg}} for more details.}

For models with group-specific parameters (e.g., models fit with 
\code{\link[rstanarm]{stan_glmer}}), setting \code{parameters="varying"}
selects the group-level parameters instead of the non-varying regression 
coefficients. Addtional columns are added indicating the \code{level} and 
\code{group}. Specifying \code{parameters="hierarchical"} selects the
standard deviations and (for certain models) correlations of the group-level
parameters.

If \code{intervals=TRUE}, columns for the \code{lower} and 
\code{upper} values of the posterior intervals computed with 
\code{\link[rstanarm]{posterior_interval}} are also included.

\code{glance} returns one row with the columns
  \item{algorithm}{The algorithm used to fit the model.}
  \item{pss}{The posterior sample size (except for models fit using 
  optimization).}
  \item{nobs}{The number of observations used to fit the model.}
  \item{sigma}{The square root of the estimated residual variance.}
  \item{looic}{If \code{looic=TRUE}, the LOO Information Criterion.}
}
\description{
These methods tidy the estimates from \code{\link[rstanarm]{stanreg-objects}}
(fitted model objects from the \pkg{rstanarm} package) into a summary.
}
\examples{
if (require(rstanarm)) {
 fit <- stan_glmer(mpg ~ wt + (1|cyl) + (1+wt|gear), data = mtcars, 
                   iter = 500, chains = 2)
 tidy(fit, intervals = TRUE, prob = 0.5)
 tidy(fit, parameters = "hierarchical")
 tidy(fit, parameters = "varying")
 glance(fit, looic = TRUE, cores = 1)
}
 
}
\seealso{
\code{\link[rstanarm]{summary.stanreg}}
}

