% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-tidiers.R
\name{tidy.density}
\alias{tidy.density}
\title{Tidy a(n) density object}
\usage{
\method{tidy}{density}(x, ...)
}
\arguments{
\item{x}{A \code{density} object returned from \code{\link[stats:density]{stats::density()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with two columns: points \code{x} where the density
is estimated, and estimated density \code{y}.
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:density]{stats::density()}}

Other stats tidiers: \code{\link{tidy.dist}},
  \code{\link{tidy.ftable}}
}
\concept{stats tidiers}
