% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantreg-rqs-tidiers.R
\name{augment.rqs}
\alias{augment.rqs}
\title{Augment data with information from a(n) rqs object}
\usage{
\method{augment}{rqs}(x, data = model.frame(x), newdata, ...)
}
\arguments{
\item{x}{An \code{rqs} object returned from \code{\link[quantreg:rq]{quantreg::rq()}}.}

\item{data}{A \code{\link[=data.frame]{data.frame()}} or \code{\link[tibble:tibble]{tibble::tibble()}} containing the original
data that was used to produce the object \code{x}. Defaults to
\code{stats::model.frame(x)} so that \code{augment(my_fit)} returns the augmented
original data. \strong{Do not} pass new data to the \code{data} argument.
Augment will report information such as influence and cooks distance for
data passed to the \code{data} argument. These measures are only defined for
the original training data.}

\item{newdata}{A \code{\link[=data.frame]{data.frame()}} or \code{\link[tibble:tibble]{tibble::tibble()}} containing all
the original predictors used to create \code{x}. Defaults to \code{NULL}, indicating
that nothing has been passed to \code{newdata}. If \code{newdata} is specified,
the \code{data} argument will be ignored.}

\item{...}{Arguments passed on to \code{quantreg::predict.rqs}
\describe{
  \item{object}{ object of class rq or rqs or rq.process produced by \code{rq} }
  \item{newdata}{An optional data frame in which to look for variables with
    which to predict.  If omitted, the fitted values are used.}
  \item{type}{For \code{predict.rq}, the  method for 'confidence' intervals, if desired. 
    If 'percentile' then one of the bootstrap methods is used to generate percentile 
    intervals for each prediction, if 'direct' then a version of the Portnoy and Zhou 
    (1998) method is used, and otherwise an estimated covariance matrix for the parameter
    estimates is used.  Further arguments to determine the choice of bootstrap
    method or covariance matrix estimate can be passed via the \dots argument.
    For \code{predict.rqs} and \code{predict.rq.process} when \code{stepfun = TRUE},
    \code{type} is "Qhat", "Fhat" or "fhat" depending  on whether the user would
    like to have estimates of the conditional quantile, distribution or density  functions
    respectively.  As noted below the two former estimates can be monotonized with the 
    function \code{rearrange}.  When the "fhat" option is invoked, a list of conditional
    density functions is returned based on Silverman's adaptive kernel method as
    implemented in \code{akj} and \code{approxfun}.}
  \item{stepfun}{If 'TRUE' return stepfunctions otherwise return matrix of predictions.
    these functions can be estimates of either the conditional quantile or distribution
    functions depending upon the \code{type} argument.  When \code{stepfun = FALSE}
    a matrix of point estimates of the conditional quantile function at the points
    specified by the \code{newdata} argument. }
  \item{na.action}{ function determining what should be done with missing values
    in 'newdata'.  The default is to predict 'NA'.}
}}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row per obseration and columns:

\item{.resid}{Residuals}
\item{.fitted}{Fitted quantiles of the model}
\item{.tau}{Quantile estimated}

Depending on the arguments passed on to \code{predict.rqs} via \code{...},
a confidence interval is also calculated on the fitted values resulting in
columns:
\item{.conf.low}{Lower confidence interval value}
\item{.conf.high}{Upper confidence interval value}

\code{predict.rqs} does not provide confidence intervals when \code{newdata}
is provided.
}
\description{
Augment accepts a model object and a dataset and adds
information about each observation in the dataset. Most commonly, this
includes predicted values in the \code{.fitted} column, residuals in the
\code{.resid} column, and standard errors for the fitted values in a \code{.se.fit}
column. New columns always begin with a \code{.} prefix to avoid overwriting
columns in the original dataset.

Users may pass data to augment via either the \code{data} argument or the
\code{newdata} argument. If the user passes data to the \code{data} argument,
it \strong{must} be exactly the data that was used to fit the model
object. Pass datasets to \code{newdata} to augment data that was not used
during model fitting. This still requires that all columns used to fit
the model are present.

Augment will often behavior different depending on whether \code{data} or
\code{newdata} is specified. This is because there is often information
associated with training observations (such as influences or related)
measures that is not meaningfully defined for new observations.

For convenience, many augment methods provide default \code{data} arguments,
so that \code{augment(fit)} will return the augmented training data. In these
cases augment tries to reconstruct the original data based on the model
object, with some varying degrees of success.

The augmented dataset is always returned as a \link[tibble:tibble]{tibble::tibble} with the
\strong{same number of rows} as the passed dataset. This means that the
passed data must be coercible to a tibble. At this time, tibbles do not
support matrix-columns. This means you should not specify a matrix
of covariates in a model formula during the original model fitting
process, and that \code{\link[splines:ns]{splines::ns()}}, \code{\link[stats:poly]{stats::poly()}} and
\code{\link[survival:Surv]{survival::Surv()}} objects are not supported in input data. If you
encounter errors, try explicitly passing a tibble, or fitting the original
model on data in a tibble.

We are in the process of defining behaviors for models fit with various
\link{na.action} arguments, but make no guarantees about behavior when data is
missing at this time.
}
\seealso{
\link{augment}, \code{\link[quantreg:rq]{quantreg::rq()}}, \code{\link[quantreg:predict.rqs]{quantreg::predict.rqs()}}

Other quantreg tidiers: \code{\link{augment.nlrq}},
  \code{\link{augment.rq}}, \code{\link{glance.nlrq}},
  \code{\link{glance.rq}}, \code{\link{tidy.nlrq}},
  \code{\link{tidy.rqs}}, \code{\link{tidy.rq}}
}
\concept{quantreg tidiers}
