% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest-tidiers.R
\name{glance.fixest}
\alias{glance.fixest}
\title{Glance at a(n) fixest object}
\usage{
\method{glance}{fixest}(x, ...)
}
\arguments{
\item{x}{A \code{fixest} object returned from any of the \code{fixest} estimators}

\item{...}{Additional arguments passed to \code{summary} and \code{confint}. Important
arguments are \code{se} and \code{cluster}. Other arguments are \code{dof}, \code{exact_dof},
\code{forceCovariance}, and \code{keepBounded}.
See \code{\link[fixest:summary.fixest]{summary.fixest}}.}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\note{
All columns listed below will be returned, but some will be \code{NA},
depending on the type of model estimated. \code{sigma}, \code{r.squared},
\code{adj.r.squared}, and \code{within.r.squared} will be NA for any model other than
\code{feols}. \code{pseudo.r.squared} will be NA for \code{feols}.
}
\examples{

if (requireNamespace("fixest", quietly = TRUE)) {

\donttest{
library(fixest)

gravity <- feols(log(Euros) ~ log(dist_km) | Origin + Destination + Product + Year, trade)

tidy(gravity)
glance(gravity)
augment(gravity, trade)

## To get robust or clustered SEs, users can either:
# 1) Or, specify the arguments directly in the tidy() call

tidy(gravity, conf.int = TRUE, cluster = c("Product", "Year"))

tidy(gravity, conf.int = TRUE, se = "threeway")

# 2) Feed tidy() a summary.fixest object that has already accepted these arguments

gravity_summ <- summary(gravity, cluster = c("Product", "Year"))
tidy(gravity_summ, conf.int = TRUE)

# Approach (1) is preferred.

}

}

}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{adj.r.squared}{Adjusted R squared statistic, which is like the R squared statistic except taking degrees of freedom into account.}
  \item{AIC}{Akaike's Information Criterion for the model.}
  \item{BIC}{Bayesian Information Criterion for the model.}
  \item{logLik}{The log-likelihood of the model. [stats::logLik()] may be a useful reference.}
  \item{nobs}{Number of observations used.}
  \item{pseudo.r.squared}{Like the R squared statistic, but for situations when the R squared statistic isn't defined.}
  \item{r.squared}{R squared statistic, or the percent of variation explained by the model. Also known as the coefficient of determination.}
  \item{sigma}{Estimated standard error of the residuals.}
  \item{within.r.squared}{R squared within fixed-effect groups.}

}
