% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmprsk-tidiers.R
\name{glance.crr}
\alias{glance.crr}
\title{Glance at a(n) crr object}
\usage{
\method{glance}{crr}(x, ...)
}
\arguments{
\item{x}{A \code{crr} object returned from \code{\link[cmprsk:crr]{cmprsk::crr()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\examples{

# feel free to ignore the following line—it allows {broom} to supply 
# examples without requiring the model-supplying package to be installed.
if (requireNamespace("cmprsk", quietly = TRUE)) {

library(cmprsk)

# time to loco-regional failure (lrf)
lrf_time <- rexp(100) 
lrf_event <- sample(0:2, 100, replace = TRUE) 
trt <- sample(0:1, 100, replace = TRUE)
strt <- sample(1:2, 100, replace = TRUE)

# fit model
x <- crr(lrf_time, lrf_event, cbind(trt, strt))

# summarize model fit with tidiers
tidy(x, conf.int = TRUE)
glance(x)

}

}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[cmprsk:crr]{cmprsk::crr()}}

Other cmprsk tidiers: 
\code{\link{tidy.crr}()}
}
\concept{cmprsk tidiers}
\concept{crr tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{converged}{Logical indicating if the model fitting procedure was succesful and converged.}
  \item{df}{Degrees of freedom used by the model.}
  \item{logLik}{The log-likelihood of the model. [stats::logLik()] may be a useful reference.}
  \item{nobs}{Number of observations used.}
  \item{statistic}{Test statistic.}

}
