% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-negbin-tidiers.R
\name{tidy.negbin}
\alias{tidy.negbin}
\title{Tidy a(n) negbin object}
\usage{
\method{tidy}{negbin}(x, conf.int = FALSE, conf.level = 0.95, exponentiate = FALSE, ...)
}
\arguments{
\item{x}{A \code{glm.nb} object returned by \code{\link[MASS:glm.nb]{MASS::glm.nb()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{exponentiate}{Logical indicating whether or not to exponentiate the
the coefficient estimates. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults
to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

# feel free to ignore the following line—it allows {broom} to supply 
# examples without requiring the model-supplying package to be installed.
if (requireNamespace("MASS", quietly = TRUE)) {
 
# load libraries for models and data
library(MASS)

# fit model
r <- glm.nb(Days ~ Sex/(Age + Eth*Lrn), data = quine)

# summarize model fit with tidiers
tidy(r)
glance(r)

}

}
\seealso{
\code{\link[MASS:glm.nb]{MASS::glm.nb()}}

Other glm.nb tidiers: 
\code{\link{glance.negbin}()}
}
\concept{glm.nb tidiers}
