% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylomatic_names.R
\name{phylomatic_names}
\alias{phylomatic_names}
\title{Phylomatic names}
\usage{
phylomatic_names(taxa, format = "isubmit", db = "ncbi")
}
\arguments{
\item{taxa}{quoted tsn number (taxonomic serial number)}

\item{format}{output format, isubmit (you can paste in to the Phylomatic
website), or 'rsubmit' to use in fxn phylomatic_tree}

\item{db}{One of "ncbi", "itis", or "apg"}
}
\value{
e.g., "pinaceae/pinus/pinus_contorta", in Phylomatic submission format.
}
\description{
Get family names to make Phylomatic input object, and
output input string to Phylomatic for use in the function phylomatic
}
\examples{
\dontrun{
mynames <- c("Poa annua", "Salix goodingii", "Helianthus annuus")
phylomatic_names(taxa = mynames, format='rsubmit')
phylomatic_names(mynames, format='rsubmit', db="apg")
phylomatic_names(mynames, format='isubmit', db="ncbi")
phylomatic_names(mynames, format='isubmit', db="apg")
}
}

