% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbladj.R
\name{rbladj}
\alias{rbladj}
\title{Run Phylocom's bladj from R}
\usage{
rbladj(tree = NULL, ages = NULL, path = NULL, fixroot = FALSE)
}
\arguments{
\item{tree}{(phylo/character) If left NULL, it is expected that you already have a
phylo file with your newick tree in your directory with your phylocom executable}

\item{ages}{(data.frame) If left NULL, it is expected that you already have an
ages file with your node names and ages in your directory with your Phylocom executable}

\item{path}{(character) Path to the folder with at least the Phylocom executable}

\item{fixroot}{(logical) If TRUE root name is changed to the oldest root in your ages file.
If FALSE (default),}
}
\description{
Run Phylocom's bladj from R
}
\details{
Download Phylocom http://phylodiversity.net/phylocom/phylocom-4.2.zip
}
\examples{
\dontrun{
library("taxize")
taxa <- names_list("species", 15)
tree <- phylomatic(taxa=taxa, get = 'POST')

path <- "~/Mac/Courses_Rice/EcolJClub563/Fall10/phylometa_stuff/R_tutorial/bladjing/"
(tree2 <- rbladj(tree, path = path, fixroot = TRUE))
plot(tree)
plot(tree2)
}
}
