% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepcAIC.R
\name{stepcAIC}
\alias{stepcAIC}
\title{Function to stepwise select the (generalized) linear mixed model
fitted via (g)lmer() or (generalized) additive (mixed) model
fitted via gamm4() with the smallest cAIC.}
\usage{
stepcAIC(object, groupCandidates = NULL, slopeCandidates = NULL,
  fixEfCandidates = NULL, numberOfPermissibleSlopes = 2,
  allowUseAcross = FALSE, direction = "backward", trace = FALSE,
  steps = 50, keep = NULL, numCores = 1, data = NULL,
  returnResult = TRUE, calcNonOptimMod = TRUE, bsType = "tp", ...)
}
\arguments{
\item{object}{fit by \code{[lme4]{lmer}}, \code{[lme4]{glmer}} or \code{[gamm4]{gamm4}} 
for which the stepwise procedure is to be computed}

\item{groupCandidates}{see slopeCandidates. Group nesting must be initiated manually, i.e. by 
listing up the string of the groups in the manner of lme4. For example \code{groupCandidates = c("a", "b", "a/b")}.}

\item{slopeCandidates}{character vectors containing names of possible new random effect groups / slopes}

\item{fixEfCandidates}{character vector containing names of possible (non-)linear fixed effects in the GAMM; 
NULL for the (g)lmer-use case}

\item{numberOfPermissibleSlopes}{how much slopes are permissible for one group RE}

\item{allowUseAcross}{allow slopes to be used in other grouping variables}

\item{direction}{character vector indicating the direction in c("both","backward","forward")}

\item{trace}{logical; should information ne printed during the running of stepcAIC?}

\item{steps}{maximum number of steps to be considered}

\item{keep}{list($fixed,$random) of formulae; which splines / fixed (fixed) or random effects (random) to be 
kept during selection must be included in the original model}

\item{numCores}{the number of cores to be used in calculations; this is done by using \code{parallel::mclapply}}

\item{data}{data.frame, from which the new REs are to be taken}

\item{returnResult}{logical; whether to return the result (best model and corresponding cAIC)}

\item{calcNonOptimMod}{logical; if FALSE, models which failed to converge are not considered for cAIC calculation}

\item{bsType}{type of splines to consider in forward gamm4 steps}

\item{...}{options for cAIC call}
}
\value{
if \code{returnResult} is \code{TRUE}, a list with the best model \code{finalModel} and
the corresponding cAIC \code{bestCAIC} is returned. 

Note that if \code{trace} is set to \code{FALSE} and \code{returnResult}
is also \code{FALSE}, the function call may not be meaningful
}
\description{
The step function searches the space of possible models in a greedy manner,
where the direction of the search is specified by the argument
direction. If direction = "forward" / = "backward", 
the function adds / exludes random effects until the cAIC can't be improved.
In the case of forward-selection, either a new grouping structure, new
slopes for the random effects or new \code{s()}-terms must be supplied to the function call.
If direction = "both", the greedy search is alternating between forward
and backward steps, where the direction is changed after each step
}
\section{Details}{
 
For use with "gamm4-objects": 
groupCandidates are interpreted as covariables and fitted as splines.
If groupCandidates does include characters such as "s(..,bs='tp')" 
the respective spline is included in the forward stepwise procedure.
}

\examples{

(fm3 <- lmer(strength ~ 1 + (1|sample) + (1|batch), Pastes))

fm3_step <- stepcAIC(fm3, direction = "backward", trace = TRUE, data = Pastes)

fm3_min <- lm(strength ~ 1, data=Pastes)

fm3_min_step <- stepcAIC(fm3_min, groupCandidates = c("batch", "sample"), 
direction="forward", data=Pastes, trace=TRUE)
fm3_min_step <- stepcAIC(fm3_min, groupCandidates = c("batch", "sample"), 
direction="both", data=Pastes, trace=TRUE)
# try using a nested group effect which is actually not nested -> warning
fm3_min_step <- stepcAIC(fm3_min, groupCandidates = c("batch", "sample", "batch/sample"), 
                         direction="both", data=Pastes, trace=TRUE)

Pastes$time <- 1:dim(Pastes)[1]
fm3_slope <- lmer(data=Pastes, strength ~ 1 + (1 + time | cask))

fm3_slope_step <- stepcAIC(fm3_slope,direction="backward", trace=TRUE, data=Pastes)



fm3_min <- lm(strength ~ 1, data=Pastes)

fm3_min_step <- stepcAIC(fm3_min,groupCandidates=c("batch","sample"),
direction="forward", data=Pastes,trace=TRUE)



fm3_inta <- lmer(strength ~ 1 + (1|sample:batch), data=Pastes)

fm3_inta_step <- stepcAIC(fm3_inta,groupCandidates=c("batch","sample"),
direction="forward", data=Pastes,trace=TRUE)

fm3_min_step2 <- stepcAIC(fm3_min,groupCandidates=c("cask","batch","sample"),
direction="forward", data=Pastes,trace=TRUE)

fm3_min_step3 <- stepcAIC(fm3_min,groupCandidates=c("cask","batch","sample"),
direction="both", data=Pastes,trace=TRUE)

\dontrun{
fm3_inta_step2 <- stepcAIC(fm3_inta,direction="backward", 
data=Pastes,trace=TRUE)
}

##### create own example


na <- 20
nb <- 25
n <- 400
a <- sample(1:na,400,replace=TRUE)
b <- factor(sample(1:nb,400,replace=TRUE))
x <- runif(n)
y <- 2 + 3 * x + a*.02 + rnorm(n) * .4
a <- factor(a)
c <- interaction(a,b)
y <- y + as.numeric(as.character(c))*5
df <- data.frame(y=y,x=x,a=a,b=b,c=c)

smallMod <- lm(y ~ x)

\dontrun{
# throw error
stepcAIC(smallMod, groupCandidates=c("a","b","c"), data=df, trace=TRUE, returnResult=FALSE)

smallMod <- lm(y ~ x, data=df)

# throw error
stepcAIC(smallMod, groupCandidates=c("a","b","c"), data=df, trace=TRUE, returnResult=FALSE)

# get it all right
mod <- stepcAIC(smallMod, groupCandidates=c("a","b","c"), 
                data=df, trace=TRUE, 
                direction="forward", returnResult=TRUE)

# make some more steps...
stepcAIC(smallMod, groupCandidates=c("a","b","c"), data=df, trace=TRUE, 
         direction="both", returnResult=FALSE)

mod1 <- lmer(y ~ x + (1|a), data=df)

stepcAIC(mod1, groupCandidates=c("b","c"), data=df, trace=TRUE, direction="forward")
stepcAIC(mod1, groupCandidates=c("b","c"), data=df, trace=TRUE, direction="both")



mod2 <- lmer(y ~ x + (1|a) + (1|c), data=df)

stepcAIC(mod2, data=df, trace=TRUE, direction="backward")

mod3 <- lmer(y ~ x + (1|a) + (1|a:b), data=df)

stepcAIC(mod3, data=df, trace=TRUE, direction="backward")

}

}
\author{
David Ruegamer
}
