% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_with_text.R
\name{image_with_text}
\alias{image_with_text}
\title{Plot a heatmap}
\usage{
image_with_text(
  mat,
  xlab = "",
  ylab = "",
  main = NULL,
  main_shift = 0.12,
  col_names = colnames(mat),
  row_names = rownames(mat),
  row_text_adj = 1,
  row_text_shift = 0,
  row_text_rotation = 0,
  col_text_rotation = 90,
  col_text_adj = 1,
  col_text_shift = 0,
  show_text = TRUE,
  cex = 0.5,
  col_text_cex = 1,
  row_text_cex = 1,
  main_cex = 1,
  split_at_vals = FALSE,
  split_points = 0,
  col_scale = "gray",
  color_spread = 50,
  light_dark = "f",
  class_mat = NULL,
  grad_dir = c("high", "low", "middle", "ends"),
  color_fun = c("linear", "exponential"),
  exp_steepness = 1,
  global_color_scale = FALSE,
  global_min = NULL,
  global_max = NULL,
  sig_digs = 3,
  use_pheatmap_colors = FALSE,
  na_col = "lightgray",
  gridlines = FALSE
)
}
\arguments{
\item{mat}{A numeric matrix to plot as a heat map}

\item{xlab}{A string label for the x axis}

\item{ylab}{A string label for the y axis}

\item{main}{A title for the plot}

\item{main_shift}{A numeric value to shift the title
along the y axis.}

\item{col_names}{A vector of strings indicating names
for the columns of the matrix. Defaults to existing column
names.}

\item{row_names}{A vector of strings indicating names
for the rows of the matrix. Defaults to existing row
names.}

\item{row_text_adj}{adjustment value for row text indicating
the centering. See \code{\link{text}}.}

\item{row_text_shift}{numeric value for shifting the row labels
toward or away from the matrix.}

\item{row_text_rotation}{Rotation value in degrees for the row labels}

\item{col_text_rotation}{Rotation value in degrees for the column labels}

\item{col_text_adj}{adjustment value for column text indicating
the centering. See \code{\link{text}}.}

\item{col_text_shift}{numeric value for shifting the column labels
toward or away from the matrix.}

\item{show_text}{Whether to write the numerical value of each cell 
in the plot.}

\item{cex}{The size of the text when show_text is TRUE}

\item{col_text_cex}{The size of the column labels}

\item{row_text_cex}{The size of the row labels}

\item{main_cex}{The size of the title of the plot}

\item{split_at_vals}{Whether to split the values into
different color classes}

\item{split_points}{If split_at_vals is TRUE, split_points
determines the boundaries of the classes. For example, if
split_points is 0, negative and positive numbers will be 
assigned to different color classes.}

\item{col_scale}{One of c("green", "purple", "orange", "blue", 
"brown", "gray") to indicate the color scale to be used. Defaults
to gray.}

\item{color_spread}{A numerical value used as input to 
\code{\link{get_color2}} indicating the numeric distance
between colors in a ramp. Smaller values produce a smaller
difference between adjacent colors in the ramp.}

\item{light_dark}{One of "l", "d", or "f" indicating whether
the colors used should be light ("l"), dark ("d"), or from
across the full spectrum ("f").}

\item{class_mat}{An optional numeric matrix defining the color 
classes of each cell in the matrix. If omitted this is calculated
by the function.}

\item{grad_dir}{A string specifying how the color gradient 
should be applied. If "high" higher values are given darker
colors. If "low", lower values are given darker colors.
If "middle" values in the middle of the spectrum are 
given darker colors, and if "end" values at the ends
of the spectrum are given darker colors.}

\item{color_fun}{Either "linear" or "exponential" indicating
how the colors should transition from light to dark across
values.}

\item{exp_steepness}{If color_fun is "exponential," exp_steepness
indicates how quickly the colors should transition from light 
to dark.}

\item{global_color_scale}{Whether to impose a global minimum
and maximum to the colors, or to use the values themselves to 
determine the top and bottom of the color scale.}

\item{global_min}{If global_color_scale is TRUE, the minimum
value that should be assigned a color.}

\item{global_max}{If global_color_scale is TRUE, the maximum
value that should be assigned a color.}

\item{sig_digs}{The number of significant figures to use
from the input matrix. Helpful primarily when show_text is TRUE.}

\item{use_pheatmap_colors}{If TRUE, all other color parameters
are ignored, and colors like those used in the R package
pheatmap are used instead.}

\item{na_col}{The color to use for missing values.}

\item{gridlines}{Whether to plot gridlines on the matrix.}
}
\value{
None
}
\description{
Plot a heatmap
}
\keyword{internal}
