% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlescan.R
\name{singlescan}
\alias{singlescan}
\title{Runs marker regression on each individual genetic marker}
\usage{
singlescan(
  data_obj,
  geno_obj,
  kin_obj = NULL,
  n_perm = 0,
  alpha = c(0.01, 0.05),
  model_family = "gaussian",
  run_parallel = FALSE,
  n_cores = 4,
  verbose = FALSE,
  overwrite_alert = TRUE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object.}

\item{kin_obj}{a kinship object. If NULL, the kinship correction is not performed.}

\item{n_perm}{integer number of permutations. Permutation results are only
used in \code{\link{plot_singlescan}}. They are not used for any other piece
of the Cape analysis and may be safely omitted. The default number of permutations
is 0.}

\item{alpha}{significance level if permutations are being run. If permutations are
run effect size thresholds for each alpha level are cacluated using the extreme value
distribution.}

\item{model_family}{A vector indicating the model family of the phenotypes. This can 
be either "gaussian" or "binomial." If length 1, all phenotypes will be assigned to the 
same family. Phenotypes can be assigned different model families by
providing a vector of the same length as the number of phenotypes,
indicating how each phenotype should be modeled.}

\item{run_parallel}{Whether to run on parallel CPUs}

\item{n_cores}{The number of CPUs to use if run_parallel is TRUE}

\item{verbose}{Whether to print progress to the screen}

\item{overwrite_alert}{Used}
}
\value{
Returns a list of the singlescan results. The list is
of length seven, and has the following elements: 
   alpha: The alpha values set in the argument alpha
   alpha_thresh: The calculated effect size thresholds at each alpha if permutations are run.
   ref_allele: The allele used as the reference allele
   singlescan_effects: The effect sizes (beta coefficients) from the single-locus linear models
   singlescan_t_stats: The t statistics from the single-locus linear models
   locus.p_vals: Marker-level p values
   locus_score_scores: Marker-level test statistics.
}
\description{
This function performs marker regression to associate
individual markers with traits (or eigentraits).
If n_perm is greater than 0, permutations are run to 
determine effect size thresholds for the alpha values
provided. The default alpha values are 0.05 and 0.01.
Covariates are specified in the cape parameter file.
}
\details{
model_family indicates the model family of the phenotypes
This can be either "gaussian" or "binomial". If this argument
is length 1, all phenotypes will be assigned to the same
family. Phenotypes can be assigned different model families by
providing a vector of the same length as the number of phenotypes,
indicating how each phenotype should be modeled.
}
\examples{
\dontrun{
singlescan_obj <- singlescan(data_obj, geno_obj, kin_obj)
}

}
\seealso{
\code{\link{plot_singlescan}}
}
