% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateSimpleSampleSize.R
\name{CalculateSimpleSampleSize}
\alias{CalculateSimpleSampleSize}
\title{Simple random sample size}
\usage{
CalculateSimpleSampleSize(x = NULL, N = NULL, conf.level = 0.95,
  error = 0.1)
}
\arguments{
\item{x}{\code{\link{vector}} pilot sample of the variable to be estimated. If x is a scalar, it is used as the relative variance of the variable to be estimated (\code{((N - 1) / N * sd(x)^2) / mean(x)^2}).}

\item{N}{\code{\link{numeric}}. indicating the number of sampling units in the population.}

\item{conf.level}{the confidence level required. It must be \code{\link{numeric}} between 0 and 1 inclusive.}

\item{error}{the maximum relative difference between the estimate and the unknown population value. It must be \code{\link{numeric}} between 0 and 1 inclusive.}
}
\value{
numeric sample size rounded up to nearest integer.
}
\description{
Calculates sample size for a simple sampling design to estimate a total.
}
\examples{
# Using a pilot sample from a population with 10000 sampling units.
pilot.sample <- rpois(50, 0.8)
CalculateSimpleSampleSize(x = pilot.sample, N = 10000,
                          conf.level = 0.95, error = 0.1)

# Using expected mean and standard deviation for a population
# with 10000 sampling units.
mean.x <- 0.98
sd.x <- 1.02
N <- 10000
V <- ((N - 1) / N * sd.x^2) / mean.x^2
CalculateSimpleSampleSize(x = V, N = 10000, conf.level = 0.95, error = 0.1)
}
\references{
Levy P and Lemeshow S (2008). Sampling of populations: methods and applications, Fourth edition. John Wiley and Sons, Inc.

\url{http://oswaldosantos.github.io/capm}
}

