/*
 *  catnet : categorical Bayesian network inference
 *  Copyright (C) 2009--2010  Nikolay Balov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, a copy is available at
 *  http://www.gnu.org/licenses/gpl-2.0.html
 */


#include "catnet_rexport.h"

size_t g_memcounter = 0;

static const R_CallMethodDef R_CallDef[] = {
	{"ccnOptimalNetsForOrder", (DL_FUNC)&catnetOptimalNetsForOrder, 11},
	{"ccnOptimalNetsSA", (DL_FUNC)&catnetOptimalNetsSA, 20},
	{"ccnParHistogram", (DL_FUNC)&catnetParHistogram, 12},
	{"ccnSetProb", (DL_FUNC)&catnetSetProb, 3},
	{"ccnLoglik", (DL_FUNC)&catnetLoglik, 3},
	{"ccnNodeLoglik", (DL_FUNC)&catnetNodeLoglik, 4},
	{"ccnNodeLoglikError", (DL_FUNC)&catnetNodeLoglikError, 4},
	{"ccnMarginalProb", (DL_FUNC)&catnetMarginalProb, 2},
	{"ccnReleaseCache", (DL_FUNC)&catnetReleaseCache, 0},
	{NULL, NULL, 0},
};

void R_init_catnet(DllInfo *info)
{
	R_registerRoutines(info,NULL,R_CallDef,NULL,NULL);
	//printf("ccnInit\n");
	g_memcounter = 0;
}

void R_unload_catnet(DllInfo *info)
{
	//printf("ccnUnload\n");
	catnetReleaseCache();
}
