##' Coupled dipole approximation
##'
##' c++ implementation of the coupled dipole approximation for scattering calculations of interacting nanoantennas, specifically targetted at plasmonic nanoparticles
##'
##' 
##' @name cda-package
##' @aliases cda
##' @docType package
##' @exportPattern "^[^\\.]"
##' @useDynLib cda
##' @import Rcpp
##' @title cda
##' @author baptiste Auguie \email{baptiste.auguie@@gmail.com}
##' @references
##' Draine BT. The discrete-dipole approximation and its application to interstellar graphite grains. Astrophysical Journal. 1988.
##' 
##' Schatz GC, Duyne RP. Discrete dipole approximation for calculating extinction and Raman intensities for small particles with arbitrary shapes. Journal of Chemical Physics. 1995.
##' 
##' Gunnarsson L, Zou S, Schatz GC, et al. Confined plasmons in nanofabricated single silver particle pairs: Experimental observations of strong interparticle interactions. Journal of Physical Chemistry B. 2005.
##' 
##' ## Any one of the following references may (should) be used to cite and acknowledge this package.
##' 
##' A. Guerrero-Martinez, B. Auguie, J.L. Alonso-Gomez, Z. Dzolic, S. Gomez-Grana, M. Zinic, M.M. Cid, L.M. Liz-Marzan. Intense Optical Activity from three-Dimensional Chiral Ordering of Plasmonic Nanoantennas. Angew. Chem. Int. Ed.50 (2011)
##' 
##' B. Auguie, J.L. Alonso-Gomez, A. Guerrero-Martinez, L.M. Liz-Marzan. Fingers crossed: circular dichroism with a dimer of plasmonic nanorods. J. Phys. Chem. Lett. 2, (2011)
##' 
##' B. Auguie, W.L. Barnes. Diffractive coupling in gold nanoparticle arrays and the effect of disorder. Optics Letters (2009)
##' 
##' B. Auguie, W.L. Barnes. Collective resonances in gold nanoparticle arrays. Physical Review Letters (2008)
##' @keywords packagelibrary
##' 
function()
  NULL
