# Guidelines for issues and requests

Thank you for using the `cda` package! Please read through these notes before submitting a request. This will increase the chances of a useful response.

## Issues related with installation or basic R syntax

If the issue is not directly related to the `cda` package, this is not the best place to discuss it. If you need help with the `R` language, or installation of the program, I suggest you ask a question on [StackOverflow.com](http://stackoverflow.com/), with a minimal reproducible example. Reading the [*Introduction to R*](https://cran.r-project.org/doc/manuals/r-release/R-intro.html) manual may also be helpful.

## Issues directly related to the `cda` package

If you face an issue with the code, please first ensure that you are using the latest version of R and of the `cda` package.

If you find a bug that is specific to the `cda` package, please do submit an issue (or send an email to the developer) with the following information:

- a brief context for the problem you are trying to solve
- a minimal reproducible example that I can copy-and-paste in a fresh R console to reproduce the problem
- the results of your `sessionInfo()` and other relevant information
- [optional] your affiliation, if you are using the package for your research
