% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrPlot.R
\name{plot.cdfqr}
\alias{plot.cdfqr}
\title{Plot Fitted Values/Residuals of A Cdfqr Object or Distribution}
\usage{
\method{plot}{cdfqr}(x, mu = NULL, sigma = NULL, fd = NULL, sd = NULL,
  n = 10000, type = c("fitted"), ...)
}
\arguments{
\item{x}{If the plot is based on the fitted values, provide a fitted cdfqr object.}

\item{mu, sigma, }{fd, sd alternatively, mu and sigma, and the distribution can be specified}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the sub-family distribution.}

\item{n}{The number of random variates to be generated for user specified plot.}

\item{type}{Currently only fitted values are available for generating plots.}

\item{...}{other plot parameters pass onto \code{\link[graphics]{plot}}.}
}
\description{
Plot Fitted Values/Residuals of A Cdfqr Object or Distribution
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2','t2', data = JurorData)
plot(fit)


}

