\name{k2k}
\alias{k2k}
\title{Reduction to k2k Matching}
\description{
Reduces a CEM output to a k2k matching
}
\usage{
k2k(obj, data, method=NULL, mpower=2, verbose=0)
}
\arguments{
  \item{obj}{an object as output from \code{cem}}
  \item{data}{the original data.frame used by \code{cem}}
  \item{method}{distance method to use in \code{k2k} matching. See Details.}
  \item{mpower}{power of the Minkowski distance. See Details.}
  \item{verbose}{controls level of verbosity. Default=0.}
}
\details{
This function transforms a typical \code{cem} matching solution
to a \code{k}-to-\code{k} match, with \code{k} variable along strata:
i.e., in each stratum generated by \code{cem}, the match is reduce to have
the same number of treated and control units.  (This option will delete
some data that matched well, and thus likely increase the  variance, but
it means that subsequent analyses do not require weights.)

The user can choose a \code{method} (between `\code{euclidean}',
`\code{maximum}', `\code{manhattan}', `\code{canberra}', `\code{binary}'
and `\code{minkowski}') for nearest neighbor matching inside each
\code{cem} strata. By default \code{method} is set to `\code{NULL}',
which means random matching inside \code{cem} strata. For the Minkowski
distance the power can be specified via the argument \code{mpower}'.
For more information on \code{method != NULL}, refer to
\code{\link{dist}} help page.

After \code{k2k} the weights of each matched observation are set to unity.
}
\value{
  \item{obj}{an object of class \code{cem.match}}
}
\references{Stefano Iacus, Gary King, Giuseppe Porro, ``Matching for
  Casual Inference Without Balance Checking: Coarsened Exact Matching,''
  http://gking.harvard.edu/files/abs/cem-abs.shtml}
\author{Stefano Iacus, Gary King, and Giuseppe Porro}
\examples{
data(LL)

# cem match: automatic bin choice
mat <- cem(treatment="treated", data=LL, drop="re78")
mat
mat$k2k

# ATT estimate
att(mat, re78 ~ treated, data=LL)


# transform the match into k2k
mat2 <- k2k(mat, LL, "euclidean", 1)
mat2
mat2$k2k

# ATT estimate after k2k
att(mat2, re78 ~ treated, data=LL)
}
\keyword{multivariate}
\keyword{datagen}


