% Generated by roxygen2 (4.0.1): do not edit by hand
\name{checkNumber}
\alias{assertNumber}
\alias{checkNumber}
\alias{testNumber}
\title{Check if an argument is a single numeric}
\usage{
checkNumber(x, na.ok = FALSE, lower = -Inf, upper = Inf, finite = FALSE)

assertNumber(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  finite = FALSE, .var.name)

testNumber(x, na.ok = FALSE, lower = -Inf, upper = Inf, finite = FALSE)
}
\arguments{
\item{x}{[ANY]\cr
Object to check.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}

\item{finite}{[\code{logical(1)}]\cr
Check for only finite values? Default is \code{FALSE}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertNumber} throws an error message,
 \code{testNumber} returns \code{FALSE} and \code{checkNumber} returns
 a string with the error message.
}
\description{
Check if an argument is a single numeric
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testNumber(1)
 testNumber(1:2)
}
\seealso{
Other scalars: \code{\link{assertCount}},
  \code{\link{checkCount}}, \code{\link{testCount}};
  \code{\link{assertFlag}}, \code{\link{checkFlag}},
  \code{\link{testFlag}}; \code{\link{assertInt}},
  \code{\link{checkInt}}, \code{\link{testInt}};
  \code{\link{assertScalarNA}},
  \code{\link{checkScalarNA}}, \code{\link{testScalarNA}};
  \code{\link{assertScalar}}, \code{\link{checkScalar}},
  \code{\link{testScalar}}; \code{\link{assertString}},
  \code{\link{checkString}}, \code{\link{testString}}
}

