% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeExpectation.r
\name{makeExpectation}
\alias{makeExpectation}
\alias{makeExpectationFunction}
\title{Turn a Check into an Expectation}
\usage{
makeExpectation(x, res, info = NULL, label = NULL)

makeExpectationFunction(check.fun, env = parent.frame())
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{res}{[\code{TRUE} | \code{character(1)}]\cr
The result of a check function: \code{TRUE} for successful checks,
and an error message as string otherwise.}

\item{info}{[\code{character(1)}]\cr
See \code{\link[testthat]{expect_that}}}

\item{label}{[\code{character(1)}]\cr
See \code{\link[testthat]{expect_that}}}

\item{check.fun}{[\code{function}]\cr
Function which checks the input. Must return \code{TRUE} on success and a string with the error message otherwise.}

\item{env}{[\code{environment}]\cr
The environment of the created function. Default is the \code{\link[base]{parent.frame}}.}
}
\value{
\code{makeExpectation} returns the expectation result.
 \code{makeExpectationFunction} returns a \code{function}.
}
\description{
\code{makeExpectation} is the internal function used to evaluate the result of a
check and turn it into an \code{\link[testthat]{expectation}}.
\code{makeExceptionFunction} can be used to automatically create an expectation
function based on a check function (see example).
}
\examples{
# Simple custom check function
checkFalse = function(x) if (!identical(x, FALSE)) "Must be FALSE" else TRUE

# Create the respective expect function
expect_false = function(x, info = NULL, label = NULL) {
  res = checkFalse(x)
  makeExpectation(res, info = info, label = label)
}

# Alternative: Automatically create such a function
expect_false = makeExpectationFunction(checkFalse)
print(expect_false)
}

