% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkPathForOutput.r
\name{checkPathForOutput}
\alias{assertPathForOutput}
\alias{assert_path_for_output}
\alias{checkPathForOutput}
\alias{expect_path_for_output}
\alias{testPathForOutput}
\alias{test_path_for_output}
\title{Check if a path is suited for creating an output file}
\usage{
checkPathForOutput(x, overwrite = FALSE)

assertPathForOutput(x, overwrite = FALSE, add = NULL, .var.name = NULL)

assert_path_for_output(x, overwrite = FALSE, add = NULL, .var.name = NULL)

testPathForOutput(x, overwrite = FALSE)

test_path_for_output(x, overwrite = FALSE)

expect_path_for_output(x, overwrite = FALSE, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{overwrite}{[\code{logical(1)}]\cr
If \code{TRUE}, an existing file in place is allowed if it
it is both readable and writeable.
Default is \code{FALSE}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertPathForOutput}/\code{assert_path_for_output}
 throws an error message, \code{testPathForOutput}/\code{test_path_for_output}
 returns \code{FALSE},
 and \code{checkPathForOutput} returns a string with the error message.
 The function \code{expect_path_for_output} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if a file path can be safely be used to create a file and write to it.

This is checked:
\itemize{
 \item{Does \code{dirname(x)} exist?}
 \item{Does no file under path \code{x} exist?}
 \item{Is \code{dirname(x)} writeable?}
}
Paths are relative to the current working directory.
}
\examples{
# Can we create a file in the tempdir?
testPathForOutput(file.path(tempdir(), "process.log"))
}
\seealso{
Other filesystem: \code{\link{checkAccess}},
  \code{\link{checkDirectory}}, \code{\link{checkFile}}
}

