% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clgeo_Clean.R
\name{clgeo_Clean}
\alias{clgeo_Clean}
\title{clgeo_Clean}
\usage{
clgeo_Clean(sp, errors.only = NULL, strategy = "POLYGONATION",
  verbose = FALSE)
}
\arguments{
\item{sp}{object extending the \code{\link[sp]{Spatial-class}}
as defined in \pkg{sp}}

\item{errors.only}{an object of class \code{vector} giving the types of errors
for which the output should bounded. Default value is NULL (\emph{i.e.} the output
will include features for which both errors and errors were raised.). At now, this
argument accepts the error type \code{"ORPHANED_HOLE"}.}

\item{strategy}{advanced strategy to clean geometries. Default is "POLYGONATION",
alternate value is "BUFFER" (old method).}

\item{verbose}{Indicates wether the clean logs have to be printed. Default
value is FALSE.}
}
\value{
an object extending the \code{\link[sp]{Spatial-class}}
as defined in \pkg{sp}, with cleaned geometries.
}
\description{
Function to clean a spatial data collection
}
\note{
About cleaning strategy:
The polygonation method is a tentative alternate method to triangulation to clean
geometries and to the classical often used 'buffer' approach. In the polygonation
method, triangulation is skipped and a re-polygonation intuitive algorithm is
applied to rebuild the source invalid geometry into one or more valid polygonal
geometries.
}
\examples{
\donttest{
 require(maptools)
 file <- system.file("extdata", "example.shp", package = "cleangeo")
 sp <- readShapePoly(file)

 sp.clean <- clgeo_Clean(sp)
 report.clean <- clgeo_CollectionReport(sp.clean)
 clgeo_SummaryReport(report.clean)
}
}
\author{
Emmanuel Blondel \email{emmanuel.blondel1@gmail.com}
}
\keyword{clean}
\keyword{geometry}
\keyword{summary}
\keyword{validity}

