/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.usermonitor;

import com.norbl.util.StringUtil;
import com.norbl.util.aws.SDBAccess;
import com.norbl.util.aws.SDBAccessException;
import java.util.ArrayList;

public class UserDb {
    SDBAccess sdbAccess;
    public static final String SDB_DOMAIN = "ppe_user_db";
    public static final String NIL = "nil";

    public UserDb(SDBAccess sdbAccess) {
        this.sdbAccess = sdbAccess;
    }

    public synchronized boolean userExists(String uid) throws SDBAccessException {
        return this.sdbAccess.getUVal(SDB_DOMAIN, El.uid.toString(), uid, El.uid.toString()) != null;
    }

    public void addUser(String uid, String peid, String callerReference, String callerReferenceSender, String callerReferenceSettlement) {
        ArrayList<SDBAccess.NamedAttribute> nats = new ArrayList<SDBAccess.NamedAttribute>();
        nats.add(new SDBAccess.NamedAttribute(El.uid.toString(), uid));
        nats.add(new SDBAccess.NamedAttribute(El.peid.toString(), peid));
        nats.add(new SDBAccess.NamedAttribute(El.callerReference.toString(), callerReference));
        nats.add(new SDBAccess.NamedAttribute(El.callerReferenceSender.toString(), callerReferenceSender));
        nats.add(new SDBAccess.NamedAttribute(El.callerReferenceSettlement.toString(), callerReferenceSettlement));
        nats.add(new SDBAccess.NamedAttribute(El.status.toString(), Status.pending.toString()));
        nats.add(new SDBAccess.NamedAttribute(El.status_time.toString(), Long.toString(System.currentTimeMillis())));
        nats.add(new SDBAccess.NamedAttribute(El.n_instance_hours_unbilled.toString(), Integer.toString(0)));
        nats.add(new SDBAccess.NamedAttribute(El.n_instance_hours_billed.toString(), Integer.toString(0)));
        nats.add(new SDBAccess.NamedAttribute(El.settlementTokenID.toString(), NIL));
        nats.add(new SDBAccess.NamedAttribute(El.creditSenderTokenID.toString(), NIL));
        nats.add(new SDBAccess.NamedAttribute(El.creditInstrumentID.toString(), NIL));
        this.sdbAccess.addAttributes(SDB_DOMAIN, uid, nats);
    }

    public void markAuthorized(String uid, String settlementTokenID, String creditSenderTokenID, String creditInstrumentID) {
        ArrayList<SDBAccess.NamedAttribute> nats = new ArrayList<SDBAccess.NamedAttribute>();
        nats.add(new SDBAccess.NamedAttribute(El.settlementTokenID.toString(), settlementTokenID));
        nats.add(new SDBAccess.NamedAttribute(El.creditSenderTokenID.toString(), creditSenderTokenID));
        nats.add(new SDBAccess.NamedAttribute(El.creditInstrumentID.toString(), creditInstrumentID));
        nats.add(new SDBAccess.NamedAttribute(El.status.toString(), Status.authorized.toString()));
        nats.add(new SDBAccess.NamedAttribute(El.status_time.toString(), Long.toString(System.currentTimeMillis())));
        this.sdbAccess.addAttributes(SDB_DOMAIN, uid, nats);
    }

    public double calcUnbilledValue(String uid) throws SDBAccessException {
        int nHours = this.getIntVal(uid, El.n_instance_hours_unbilled);
        return (double)nHours * 0.03;
    }

    public void incrementNInstanceHours(String uid) throws SDBAccessException, NumberFormatException {
        int n = this.getIntVal(uid, El.n_instance_hours_unbilled);
        this.putIntVal(uid, El.n_instance_hours_unbilled, ++n);
    }

    public void markBilled(String uid) throws SDBAccessException {
        int nHoursUnbilled = this.getIntVal(uid, El.n_instance_hours_unbilled);
        int nHoursbilled = this.getIntVal(uid, El.n_instance_hours_billed);
        this.putIntVal(uid, El.n_instance_hours_unbilled, 0);
        this.putIntVal(uid, El.n_instance_hours_billed, nHoursbilled + nHoursUnbilled);
    }

    private void putVal(String uid, El elToSet, String val) {
        this.sdbAccess.addAttribute(SDB_DOMAIN, uid, elToSet.toString(), val);
    }

    private String getVal(String uid, String soughtAttributeName) throws SDBAccessException {
        return this.sdbAccess.getUVal(SDB_DOMAIN, El.uid.toString(), uid, soughtAttributeName);
    }

    private int getIntVal(String uid, El el) throws SDBAccessException {
        String s = this.getVal(uid, el.toString());
        if (s != null) {
            return Integer.parseInt(s);
        }
        throw new SDBAccessException("No value for " + StringUtil.toStringNull((Object)el) + " uid=" + uid);
    }

    private void putIntVal(String uid, El el, int val) {
        this.putVal(uid, el, Integer.toString(val));
    }

    public static enum Status {
        pending,
        authorized,
        nil;

    }

    public static enum El {
        uid,
        peid,
        callerReference,
        callerReferenceSender,
        callerReferenceSettlement,
        status,
        status_time,
        n_instance_hours_unbilled,
        n_instance_hours_billed,
        settlementTokenID,
        creditSenderTokenID,
        creditInstrumentID;

    }
}

