/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.gui.networkspec;

import com.norbl.cbp.ppe.gui.networkspec.Choice;
import com.norbl.cbp.ppe.gui.networkspec.ChoiceSet;
import com.norbl.cbp.ppe.gui.networkspec.OtherCC;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ChoiceMenu
extends JPanel {
    ButtonGroup buttonGroup;
    OtherCC otherCC;

    public void build(ChoiceSet cs, ActionListener actionListener) {
        if (cs.getNColumns() == 1) {
            this.buildSingleColumnMenu(cs, actionListener);
        } else {
            this.buildMultiColumnMenu(cs, actionListener);
        }
    }

    public void emptyMenu() {
        this.removeAll();
    }

    private void buildSingleColumnMenu(ChoiceSet cs, ActionListener actionListener) {
        this.removeAll();
        this.setLayout(new GridLayout(cs.size(), 1));
        this.buttonGroup = new ButtonGroup();
        for (Choice c : cs) {
            c.createCC();
            c.cc.addActionListener(actionListener);
            Object val = c.getValue();
            c.cc.setActionCommand(c.ID);
            JRadioButton b = c.cc.getRadioButton();
            b.setToolTipText(c.getToolTip());
            if (b != null) {
                this.buttonGroup.add(b);
            }
            this.add(c.getComponent());
            if (!c.enabled) continue;
            c.cc.setEnabled(true);
        }
    }

    private void buildMultiColumnMenu(ChoiceSet cs, ActionListener actionListener) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.buttonGroup = new ButtonGroup();
        Choice c0 = (Choice)cs.get(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        for (int iCol = 0; iCol < cs.getNColumns(); ++iCol) {
            gbc = new GridBagConstraints();
            gbc.gridx = iCol;
            gbc.gridy = 0;
            gbc.anchor = c0.getGridBagAnchor(iCol);
            gbc.weightx = c0.getColumnWeight(iCol);
            gbc.insets = c0.getInsets(iCol);
            JLabel t = new JLabel(c0.getColumnName(iCol));
            c0.setColumnHeaderToolTip(iCol, t);
            Font f = t.getFont();
            t.setFont(new Font(f.getName(), 1, f.getSize()));
            this.add((Component)t, gbc);
        }
        for (int iRow = 0; iRow < cs.size(); ++iRow) {
            Choice c = (Choice)cs.get(iRow);
            c.createCC();
            c.cc.addActionListener(actionListener);
            Object val = c.getValue();
            c.cc.setActionCommand(c.ID);
            JRadioButton b = c.cc.getRadioButton();
            b.setToolTipText(c.getToolTip());
            if (b != null) {
                this.buttonGroup.add(b);
            }
            if (c.enabled) {
                c.cc.setEnabled(true);
            }
            if (c.cc instanceof OtherCC) {
                this.otherCC = (OtherCC)c.cc;
                continue;
            }
            gbc.gridx = 0;
            gbc.gridy = iRow + 1;
            gbc.weightx = c.getColumnWeight(0);
            gbc.anchor = c.getGridBagAnchor(0);
            gbc.insets = c0.getInsets(0);
            this.add((Component)c.cc.getComponent(), gbc);
            for (int iCol = 1; iCol < c.getNColumns(); ++iCol) {
                gbc = new GridBagConstraints();
                gbc.fill = 0;
                gbc.gridx = iCol;
                gbc.gridy = iRow + 1;
                gbc.anchor = c.getGridBagAnchor(iCol);
                gbc.weightx = c.getColumnWeight(iCol);
                gbc.insets = c0.getInsets(iCol);
                this.add((Component)c.getComponent(iCol), gbc);
            }
        }
    }
}

