% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fill_gradient2.R
\name{rule_fill_gradient2}
\alias{rule_fill_gradient2}
\title{Fill column with divergent colour gradient}
\usage{
rule_fill_gradient2(..., expression, low = scales::muted("red"),
  mid = "white", high = scales::muted("blue"), midpoint = NA,
  space = "Lab", na.value = "#7F7F7F", limits = NA, lockcells = FALSE)
}
\arguments{
\item{...}{Comma separated list of unquoted column names.
If \code{expression} is also given, then this list can use any of the
\code{\link[dplyr]{select}} syntax possibilities.}

\item{expression}{an expression to be evaluated with the data.
It should evaluate to a numeric vector,
that will be used to determine the colour gradient level.}

\item{low}{colour for low end of gradient.}

\item{mid}{colour for mid point}

\item{high}{colour for high end of gradient.}

\item{midpoint}{the value used for the middle color (the median by default)}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{fill color for missing values}

\item{limits}{range of limits that the gradient should cover}

\item{lockcells}{logical value determining if no further rules should be applied to the affected cells.}
}
\value{
The condformat_tbl object, with the added formatting information
}
\description{
Fills the background color of a column using a three colors gradient based on
the values of an expression
}
\examples{
data(iris)
condformat(iris[c(1:5, 70:75, 120:125), ]) +
 rule_fill_gradient2(Sepal.Length) +
 rule_fill_gradient2(Species, expression=Sepal.Length - Sepal.Width)
}
\seealso{
Other rule: \code{\link{rule_fill_discrete_}},
  \code{\link{rule_fill_discrete}},
  \code{\link{rule_fill_gradient2_}},
  \code{\link{rule_fill_gradient_}},
  \code{\link{rule_fill_gradient}}
}

