% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/maxdist.R
\name{maxdist}
\alias{maxdist}
\title{Calculates the maximum phenotypic distance between the lineages leading to a pair of taxa.}
\usage{
maxdist(phyl, phendata, t1, t2)
}
\arguments{
\item{phyl}{The phylogeny of interest in phylo format}

\item{phendata}{Phenotypic data for all tips}

\item{t1}{The first taxon of interest}

\item{t2}{The second taxon of interest}
}
\value{
The maximum phenotypic distance between the two taxa
}
\description{
maxdist uses ancestral state reconstruction to determine the maximum distance between any ancestors of those two taxa.
}
\details{
Returns the maximum Euclidean distance between any pair of ancestors of the two taxa, whether or not those two ancestors are contemporaries.
}
\examples{
phyl<-rtree(10)
phendata<-fastBM(phyl,nsim=2)
answer<-maxdist(phyl,phendata,1,10)
}
\references{
Paradis, E., J. Claude, and K. Strimmer (2004) APE: Analyses of phylogenetics
and evolution in R langauge. Bioinformatics, 20, 289-290.

Revell, L. J. (2012) phytools: An R package for phylogenetic comparative
biology (and other things). Methods Ecol. Evol. 3 217-223.
}

