% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_utils.r
\name{sparsity}
\alias{sparsity}
\title{Sparsity}
\usage{
sparsity(x, proportion = TRUE)
}
\arguments{
\item{x}{The matrix, stored as an ordinary R matrix or as a "simple
triplet matrix" (from the slam package).}

\item{proportion}{Logical; should a proportion or a count be returned?}
}
\value{
The sparsity of the input matrix, as a proportion or a count.
}
\description{
Show the sparsity (as a count or proportion) of a matrix.  For
example, .99 sparsity means 99\% of the values are zero.
Similarly, a sparsity of 0 means the matrix is fully dense.
}
\details{
The implementation is very efficient for dense matrices.  For
sparse triplet matrices, the count is trivial.
}
\examples{
## Completely sparse matrix
x <- matrix(0, 10, 10)
coop::sparsity(x)

## 15\\\% density / 85\\\% sparsity
x[sample(length(x), size=15)] <- 1
coop::sparsity(x)

}
\author{
Drew Schmidt
}

