/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.pojo;

import uno.informatics.data.Entity;
import uno.informatics.data.OntologyTerm;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.pojo.OntologyTermPojo;
import uno.informatics.data.pojo.SimpleEntityPojo;

public class EntityPojo
extends SimpleEntityPojo
implements Entity {
    public static final String ABBREVIATION_PROPERTY = SimpleEntity.class.getName() + ".abbreviation";
    public static final String TYPE_PROPERTY = SimpleEntity.class.getName() + ".type";
    public static final String DESCRIPTION_PROPERTY = SimpleEntity.class.getName() + ".description";
    private String description;
    private String abbreviation;
    private OntologyTermPojo type;

    public EntityPojo(String uniqueIdentifier) {
        this(uniqueIdentifier, uniqueIdentifier, null);
    }

    public EntityPojo(String uniqueIdentifier, String name) {
        this(uniqueIdentifier, name, null);
    }

    public EntityPojo(String uniqueIdentifier, String name, String description) {
        super(uniqueIdentifier, name);
        this.setDescription(description);
    }

    public EntityPojo(Entity entity) {
        super(entity);
        if (entity == null) {
            throw new IllegalArgumentException("Entity is not optional!");
        }
        this.setDescription(entity.getDescription());
        this.setAbbreviation(entity.getAbbreviation());
        this.setType(entity.getType());
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        String oldValue = this.description;
        this.description = description;
        this.getPropertyChangeSupport().firePropertyChange(DESCRIPTION_PROPERTY, oldValue, this.description);
    }

    @Override
    public final String getAbbreviation() {
        return this.abbreviation;
    }

    public final void setAbbreviation(String abbreviation) {
        String oldValue = this.abbreviation;
        this.abbreviation = abbreviation;
        this.getPropertyChangeSupport().firePropertyChange(ABBREVIATION_PROPERTY, oldValue, this.abbreviation);
    }

    @Override
    public final OntologyTerm getType() {
        return this.type;
    }

    public final void setType(OntologyTerm type) {
        OntologyTermPojo oldValue = this.type;
        this.type = type != null ? new OntologyTermPojo(type) : null;
        this.getPropertyChangeSupport().firePropertyChange(TYPE_PROPERTY, oldValue, this.type);
    }
}

