% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aab-num-ansi-colors.R
\name{num_ansi_colors}
\alias{num_ansi_colors}
\alias{detect_tty_colors}
\title{Detect the number of ANSI colors to use}
\usage{
num_ansi_colors(stream = "auto")

detect_tty_colors()
}
\arguments{
\item{stream}{The stream that will be used for output, an R connection
object. It can also be a string, one of \code{"auto"}, \code{"message"},
\code{"stdout"}, \code{"stderr"}. \code{"auto"} will select \code{stdout()} if the session is
interactive and there are no sinks, otherwise it will select \code{stderr()}.}
}
\value{
Integer, the number of ANSI colors the current R session
supports for \code{stream}.
}
\description{
Certain Unix and Windows terminals, and also certain R GUIs, e.g.
RStudio, support styling terminal output using special control
sequences (ANSI sequences).

\code{num_ansi_colors()} detects if the current R session supports ANSI
sequences, and if it does how many colors are supported.
}
\details{
The detection mechanism is quite involved and it is designed to work
out of the box on most systems. If it does not work on your system,
please report a bug. Setting options and environment variables to turn
on ANSI support is error prone, because they are inherited in other
environments, e.g. knitr, that might not have ANSI support.

If you want to \emph{turn off} ANSI colors, set the \code{NO_COLOR} environment
variable to a non-empty value.

The exact detection mechanism is as follows:
\enumerate{
\item If the \code{cli.num_colors} options is set, that is returned.
\item If the \code{R_CLI_NUM_COLORS} environment variable is set to a
non-empty value, then it is used.
\item If the \code{crayon.enabled} option is set to \code{FALSE}, 1L is returned.
(This is for compatibility with code that uses the crayon package.)
\item If the \code{crayon.enabled} option is set to \code{TRUE} and the
\code{crayon.colors} option is not set, then 8L is returned.
\item If the \code{crayon.enabled} option is set to \code{TRUE} and the
\code{crayon.colors} option is also set, then the latter is returned.
(This is for compatibility with code that uses the crayon package.)
\item If the \code{NO_COLOR} environment variable is set, then 1L is returned.
\item If we are in knitr, then 1L is returned, to turn off colors in
\code{.Rmd} chunks.
\item If \code{stream} is \code{"auto"} (the default) and there is an active
sink (either for \code{"output"} or \code{"message"}), then we return 1L.
(In theory we would only need to check the stream that will be
be actually used, but there is no easy way to tell that.)
\item If \code{stream} is not \code{"auto"}, but it is \code{stderr()} and there is an
active sink for it, then 1L is returned.
(If a sink is active for "output", then R changes the \code{stdout()}
stream, so this check is not needed.)
\item If R is running inside RGui on Windows, or R.app on macOS, then we
return 1L.
\item If R is running inside RStudio, with color support, then the
appropriate number of colors is returned, usually 256L.
\item If R is running on Windows, inside an Emacs version that is recent
enough to support ANSI colors, then 8L is returned. (On Windows,
Emacs has \code{isatty(stdout()) == FALSE}, so we need to check for this
here before dealing with terminals.)
\item If \code{stream} is not the standard output or standard error  in a
terminal, then 1L is returned.
\item Otherwise we use and cache the result of the terminal color
detection (see below).
}

The terminal color detection algorithm:
\enumerate{
\item If the \code{COLORTERM} environment variable is set to \code{truecolor} or
\verb{24bit}, then we return 16 million colors.
\item If the \code{COLORTERM} environment variable is set to anything else,
then we return 8L.
\item If R is running on Unix, inside an Emacs version that is recent
enough to support ANSI colors, then 8L is returned.
\item If we are on Windows in an RStudio terminal, then apparently
we only have eight colors.
\item If we are in a recent enough Windows 10 terminal, then there
is either true color (from build 14931) or 256 color (from
build 10586) support.
\item If we are on Windows, under ConEmu or cmder, or ANSICON is loaded,
then 8L is returned.
\item Otherwise if we are on Windows, return 1L.
\item Otherwise we are on Unix and try to run \verb{tput colors} to determine
the number of colors. If this succeeds, we return its return value.
If the \code{TERM} environment variable is \code{xterm} and \code{tput}
returned 8L, we return 256L, because xterm compatible terminals
tend to support 256 colors
(\url{https://github.com/r-lib/crayon/issues/17})
\item If \code{TERM} is set to \code{dumb}, we return 1L.
\item If \code{TERM} starts with \code{screen}, \code{xterm}, or \code{vt100}, we return 8L.
\item If \code{TERM} contains \code{color}, \code{ansi}, \code{cygwin} or \code{linux}, we return 8L.
\item Otherwise we return 1L.
}
}
\examples{
num_ansi_colors()

}
\concept{ANSI styling}
