% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-methods.R
\docType{methods}
\name{or-Stopping-StoppingAny}
\alias{or-Stopping-StoppingAny}
\alias{|,StoppingAny,Stopping-method}
\title{The method combining a stopping list and an atomic}
\usage{
\S4method{|}{StoppingAny,Stopping}(e1, e2)
}
\arguments{
\item{e1}{\code{\linkS4class{StoppingAny}} object}

\item{e2}{\code{\linkS4class{Stopping}} object}
}
\value{
The modified \code{\linkS4class{StoppingAny}} object
}
\description{
The method combining a stopping list and an atomic
}
\examples{

## Example of combining a list of stopping rules with an atomic stopping rule
## with an OR ('|') operator

myStopping1 <- StoppingMinCohorts(nCohorts=3)
myStopping2 <- StoppingTargetProb(target=c(0.2, 0.35),
                                  prob=0.5)

myStopping3 <- StoppingMinPatients(nPatients=20)

myStopping <- (myStopping1 & myStopping2 ) | myStopping3 




}
\keyword{methods}

