% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-methods.R
\docType{methods}
\name{summary,PseudoDualFlexiSimulations-method}
\alias{summary,PseudoDualFlexiSimulations-method}
\title{Summary for Pseudo Dual responses simulations given a pseudo DLE model and the Flexible efficacy model.}
\usage{
\S4method{summary}{PseudoDualFlexiSimulations}(object, trueDLE, trueEff,
  targetEndOfTrial = 0.3, targetDuringTrial = 0.35, ...)
}
\arguments{
\item{object}{the \code{\linkS4class{PseudoDualFlexiSimulations}} object we want to summarize}

\item{trueDLE}{a function which takes as input a dose (vector) and returns the true probability of DLE (vector)}

\item{trueEff}{a vector which takes as input the true mean efficacy values at all dose levels (in order)}

\item{targetEndOfTrial}{the target probability of DLE that are used at the end of a trial. Default at 0.3.}

\item{targetDuringTrial}{the target probability of DLE that are used during the trial. Default at 0.35.}

\item{\dots}{Additional arguments can be supplied here for \code{trueDLE} and \code{trueEff}}
}
\value{
an object of class \code{\linkS4class{PseudoDualSimulationsSummary}}
}
\description{
Summary for Pseudo Dual responses simulations given a pseudo DLE model and the Flexible efficacy model.
}
\examples{

##If DLE and efficacy responses are considered in the simulations and the 'EffFlexi' class is used 
## we need a data object with doses >= 1:
data <- DataDual(doseGrid=seq(25,300,25))
##First for the DLE model 
##The DLE model must be of 'ModelTox' (e.g 'LogisticIndepBeta') class 
DLEmodel <- LogisticIndepBeta(binDLE=c(1.05,1.8),
                              DLEweights=c(3,3),
                              DLEdose=c(25,300),
                              data=data)

## for the efficacy model
Effmodel<- EffFlexi(Eff=c(1.223, 2.513),Effdose=c(25,300),
                    sigma2=c(a=0.1,b=0.1),sigma2betaW=c(a=20,b=50),smooth="RW2",data=data)


##specified the next best
mynextbest<-NextBestMaxGainSamples(DLEDuringTrialtarget=0.35,
                                   DLEEndOfTrialtarget=0.3,
                                   TDderive=function(TDsamples){
                                     quantile(TDsamples,prob=0.3)},
                                   Gstarderive=function(Gstarsamples){
                                     quantile(Gstarsamples,prob=0.5)})

##The increments (see Increments class examples) 
## 200\% allowable increase for dose below 300 and 200\% increase for dose above 300
myIncrements<-IncrementsRelative(intervals=c(25,300),
                                 increments=c(2,2))
##cohort size of 3
mySize<-CohortSizeConst(size=3)
##Stop only when 10 subjects are treated:
## very low sample size is just for illustration here
myStopping <- StoppingMinPatients(nPatients=10)

##Specified the design 
design <- DualResponsesSamplesDesign(nextBest=mynextbest,
                                     cohortSize=mySize,
                                     startingDose=25,
                                     model=DLEmodel,
                                     Effmodel=Effmodel,
                                     data=data,
                                     stopping=myStopping,
                                     increments=myIncrements)
##specified the true DLE curve and the true expected efficacy values at all dose levels
myTruthDLE<- function(dose)
{ DLEmodel@prob(dose, phi1=-53.66584, phi2=10.50499)
}

myTruthEff<- c(-0.5478867, 0.1645417,  0.5248031,  0.7604467,  
               0.9333009  ,1.0687031,  1.1793942 , 1.2726408 , 
               1.3529598 , 1.4233411 , 1.4858613 , 1.5420182)


##specify the options for MCMC
#For illustration purpose, we use 10 burn-in and generate 100 samples
options<-McmcOptions(burnin=10,step=1,samples=100)
##The simulation
##For illustration purpose only 1 simulation is produced (nsim=1). 
mySim<-simulate(object=design,
                args=NULL,
                trueDLE=myTruthDLE,
                trueEff=myTruthEff,
                trueSigma2=0.025,
                trueSigma2betaW=1,
                nsim=1,
                seed=819,
                parallel=FALSE,
                mcmcOptions=options)
##summarize the simulation results
summary(mySim,
        trueDLE=myTruthDLE,
        trueEff=myTruthEff)
}
\keyword{methods}

