% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model-class.R
\docType{class}
\name{DualEndpointBeta-class}
\alias{DualEndpointBeta-class}
\alias{.DualEndpointBeta}
\alias{DualEndpointBeta}
\alias{.DefaultDualEndpointBeta}
\title{\code{DualEndpointBeta}}
\usage{
DualEndpointBeta(E0, Emax, delta1, mode, ref_dose_beta = 1, ...)

.DefaultDualEndpointBeta()
}
\arguments{
\item{E0}{(\code{numeric})\cr either a fixed number or the two uniform distribution
parameters.}

\item{Emax}{(\code{numeric})\cr either a fixed number or the two uniform distribution
parameters.}

\item{delta1}{(\code{numeric})\cr either a fixed positive number or the two parameters
of the uniform distribution, that can take only positive values.}

\item{mode}{(\code{numeric})\cr either a fixed positive number or the two parameters
of the uniform distribution, that can take only positive values.}

\item{ref_dose_beta}{(\code{number})\cr the reference dose \eqn{x*} (strictly
positive number). Note that this is different from the \code{ref_dose} in the
inherited \code{\link{DualEndpoint}} model).}

\item{...}{parameters passed to \code{\link[=DualEndpoint]{DualEndpoint()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{DualEndpointBeta}} is the class for the dual endpoint model with beta
function for dose-biomarker relationship.
}
\details{
This class extends the \code{\link{DualEndpoint}} class so that the dose-biomarker
relationship \eqn{f(x)} is modelled by a parametric, rescaled beta density
function:
\deqn{f(x) = E0 + (Emax - E0) * Beta(delta1, delta2) * (x/x*)^{delta1} * (1 - x/x*)^{delta2},}
where \eqn{x*} is the maximum dose (end of the dose range to be considered),
\eqn{delta1} and \eqn{delta2} are the two beta function parameters, and
\eqn{E0}, \eqn{Emax} are the minimum and maximum levels, respectively.
For ease of interpretation, we use the parametrization based on \eqn{delta1}
and the mode, where
\deqn{mode = delta1 / (delta1 + delta2),}
so that multiplying this by \eqn{x*} gives the mode on the dose grid.

All parameters can currently be assigned uniform distributions or be fixed
in advance. Note that \code{E0} and \code{Emax} can have negative values or
uniform distributions reaching into negative range, while \code{delta1} and
\code{mode} must be positive or have uniform distributions in the positive
range.
}
\section{Slots}{

\describe{
\item{\code{E0}}{(\code{numeric})\cr either a fixed number or the two uniform distribution
parameters.}

\item{\code{Emax}}{(\code{numeric})\cr either a fixed number or the two uniform
distribution parameters.}

\item{\code{delta1}}{(\code{numeric})\cr either a fixed positive number or the two
parameters of the uniform distribution, that can take only positive values.}

\item{\code{mode}}{(\code{numeric})\cr either a fixed positive number or the two
parameters of the uniform distribution, that can take only positive values.}

\item{\code{ref_dose_beta}}{(\code{positive_number})\cr the reference dose \eqn{x*} (note
that this is different from the \code{ref_dose} in the inherited \code{\link{DualEndpoint}}
model).}
}}

\note{
Typically, end users will not use the \code{.DefaultDualEndpointBeta()} function.
}
\examples{
my_model <- DualEndpointBeta(
  mean = c(0, 1),
  cov = matrix(c(1, 0, 0, 1), nrow = 2),
  ref_dose = 10,
  use_log_dose = TRUE,
  sigma2W = c(a = 0.1, b = 0.1),
  rho = c(a = 1, b = 1),
  E0 = c(0, 100),
  Emax = c(0, 500),
  delta1 = c(0, 5),
  mode = c(1, 15),
  ref_dose_beta = 1000
)
}
\seealso{
\code{\link{DualEndpoint}}, \code{\link{DualEndpointRW}}, \code{\link{DualEndpointEmax}}.
}
