% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{PseudoSimulations-class}
\alias{PseudoSimulations-class}
\alias{.PseudoSimulations}
\alias{PseudoSimulations}
\alias{.DefaultPseudoSimulations}
\title{\code{PseudoSimulations}}
\usage{
PseudoSimulations(
  fit,
  final_td_target_during_trial_estimates,
  final_td_target_end_of_trial_estimates,
  final_td_target_during_trial_at_dose_grid,
  final_td_target_end_of_trial_at_dose_grid,
  final_tdeot_cis,
  final_tdeot_ratios,
  final_cis,
  final_ratios,
  stop_report,
  stop_reasons,
  ...
)

.DefaultPseudoSimulations()
}
\arguments{
\item{fit}{(\code{list})\cr see slot definition.}

\item{final_td_target_during_trial_estimates}{(\code{numeric})\cr see slot definition.}

\item{final_td_target_end_of_trial_estimates}{(\code{numeric})\cr see slot definition.}

\item{final_td_target_during_trial_at_dose_grid}{(\code{numeric})\cr see slot definition.}

\item{final_td_target_end_of_trial_at_dose_grid}{(\code{numeric})\cr see slot definition.}

\item{final_tdeot_cis}{(\code{list})\cr see slot definition.}

\item{final_tdeot_ratios}{(\code{numeric})\cr see slot definition.}

\item{final_cis}{(\code{list})\cr see slot definition.}

\item{final_ratios}{(\code{numeric})\cr see slot definition.}

\item{stop_report}{see \code{\link{PseudoSimulations}}}

\item{stop_reasons}{(\code{list})\cr see slot definition.}

\item{\dots}{additional parameters from \code{\link{GeneralSimulations}}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
This class captures trial simulations from designs using pseudo model.
It has additional slots \code{fit} and \code{stop_reasons} compared to the
general class \code{\link{GeneralSimulations}}.
}
\section{Slots}{

\describe{
\item{\code{fit}}{(\code{list})\cr final fit values.}

\item{\code{final_td_target_during_trial_estimates}}{(\code{numeric})\cr final estimates of the \code{td_target_during_trial}.}

\item{\code{final_td_target_end_of_trial_estimates}}{(\code{numeric})\cr final estimates of the \code{td_target_end_of_trial}.}

\item{\code{final_td_target_during_trial_at_dose_grid}}{(\code{numeric})
\cr dose levels at dose grid closest below the final \code{td_target_during_trial} estimates.}

\item{\code{final_td_target_end_of_trial_at_dose_grid}}{(\code{numeric})
\cr dose levels at dose grid closest below the final \code{td_target_end_of_trial} estimates.}

\item{\code{final_tdeot_cis}}{(\code{list})\cr 95\% credibility intervals of the final estimates for \code{td_target_end_of_trial}.}

\item{\code{final_tdeot_ratios}}{(\code{numeric})\cr ratio of the upper to the lower 95\%
credibility intervals for \code{td_target_end_of_trial}.}

\item{\code{final_cis}}{(\code{list})\cr final 95\% credibility intervals for \code{td_target_end_of_trial} estimates.}

\item{\code{final_ratios}}{(\code{numeric})\cr final ratios of the upper to the lower 95\%
credibility interval for \code{td_target_end_of_trial}.}

\item{\code{stop_report}}{(\code{matrix})\cr outcomes of stopping rules.}

\item{\code{stop_reasons}}{(\code{list})\cr reasons for stopping each simulation run.}
}}

\note{
Typically, end users will not use the \code{.DefaultPseudoSimulations()} function.
}
