% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/versions.R
\name{restoreVersion}
\alias{restoreVersion}
\title{Restore a dataset to a previously saved version}
\usage{
restoreVersion(dataset, version)
}
\arguments{
\item{dataset}{a \code{CrunchDataset}}

\item{version}{either the name ("description") of the version to restore to
or the integer index of the version, as given by \code{versions(dataset)}}
}
\value{
\code{dataset}, rolled back to \code{version}.
}
\description{
You can save a version of a dataset using \code{\link[=saveVersion]{saveVersion()}}.
Savepoints are also created automatically by
certain Crunch functions that make major changes to the dataset. You can
get the list of saved versions with the \code{\link[=versions]{versions()}} function.
}
\seealso{
\link{versions} \link{saveVersion}
}
