\name{fdrCsSAM}
\alias{fdrCsSAM}
\title{fdrCsSAM}
\usage{
  fdrCsSAM(G, cc, y, n, numcell, numgene, rhat, nperms,
    alternative = "two.sided", standardize = TRUE,
    medianCenter = TRUE, logRm = FALSE, logBase = 2,
    nonNeg = FALSE)
}
\arguments{
  \item{G}{Matrix of gene expression, columns ordered in
  the same order at the cell-frequency matrix (n by p, n
  samples, p genes)}

  \item{cc}{Matrix of cell-frequency. (n by k, n samples, k
  cell-types)}

  \item{y}{A numeric vector of group association of each
  sample. Either 1 or 2.}

  \item{n}{A nuermic vector describing the number of
  samples in a group}

  \item{numcell}{The number of cell-types to consider}

  \item{numgene}{The number of genes being considered}

  \item{rhat}{The contrast in cell-type expression for each
  cell-type as observed between the two groups being
  compared.}

  \item{nperms}{The number of permutations to perform.}

  \item{alternative}{Type of test to conduct - choose
  between 'two.sided','greater',or 'less'}

  \item{standardize}{Standardize sample or not. Default is
  TRUE}

  \item{medianCenter}{Median center rhat distributions.
  Default is TRUE.}

  \item{logRm}{Exponentiate data for deconvolution stage.
  Default is FALSE}

  \item{logBase}{Base of logaritm used to determine
  exponentiation factor. Default is 2}

  \item{nonNeg}{For single channel arrays. Set any
  cell-specific expression estimated as negative, to a
  ceiling of 0. It is conservative in its study of
  differential expression. Default is FALSE.}
}
\value{
  A list. \item{fdr.g}{A matirx false dicovery rates for
  csSAM comparison for each cell-type at different
  thresholds. A set of 100 theresholds is determined
  automatically from the data (k by 100, where k is number
  of cells).} \item{avrhatperm}{} \item{rhatperm}{A matrix
  sized pXkXg which stores the contrast of a given gene g
  in cell type k in permutation p of the data.}
  \item{cutp.g}{A matrix k by 100, where k is the number of
  cell tpes. Lists the 100 cutoff thresholds for each
  cell-type as determined automatically from the computed
  contrast.} \item{rhat}{A matrix object with the result of
  contrasting the average cell-specific expression profile
  of the two groups, per cell-type (Size k by g where k is
  the number of cells and g is the number of genes).}
  \item{ncall.g}{Number of genes called significant at the
  given cutoff threshold with a FDR matching that indicated
  in fdr.g}
}
\description{
  Estimates the false discovery rate for the identified
  cell-specific differences in gene expression.
}
\author{
  Shai Shen-Orr, Rob Tibshirani, Narasimhan
  Balasubramanian, David Wang
}
\references{
  Shen-Orr SS, Tibshirani R, Khatri P, Bodian DL, Staedtler
  F, Perry NM, Hastie T, Sarwal MM, Davis MM and Butte AJ
  (2010). "Cell type-specific gene expression differences
  in complex tissues." _Nature methods_, *7*(4), pp. 287-9.
  ISSN 1548-7105, <URL:
  http://dx.doi.org/10.1038/nmeth.1439>, <URL:
  http://www.ncbi.nlm.nih.gov/pubmed/20208531>.
}

