/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static List getContents(String textFileName) throws FileNotFoundException, IOException {
        ArrayList<String> contents = new ArrayList<String>();
        FileReader fileReader = new FileReader(textFileName);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = bufferedReader.readLine();
        while (line != null) {
            contents.add(line);
            line = bufferedReader.readLine();
        }
        return contents;
    }

    public static void setContents(String textFileName, String contents) throws IOException {
        FileWriter fileWriter = new FileWriter(textFileName, false);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(contents);
        bufferedWriter.flush();
        bufferedWriter.close();
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getContents(InputStream inputStream) throws IOException {
        ArrayList<String> contents = new ArrayList<String>();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String line = bufferedReader.readLine();
                while (line != null) {
                    contents.add(line);
                    line = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        finally {
            inputStreamReader.close();
        }
        return contents;
    }

    public static void setContents(String textFileName, List lines) throws IOException {
        String contents = "";
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String line = (String)i.next();
            contents = contents + line + System.getProperty("line.separator");
        }
        FileUtil.setContents(textFileName, contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(Collection files, File zipFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                ZipOutputStream zos = new ZipOutputStream(bos);
                try {
                    Iterator i = files.iterator();
                    while (i.hasNext()) {
                        File file = (File)i.next();
                        zos.putNextEntry(new ZipEntry(file.getName()));
                        FileInputStream fis = new FileInputStream(file);
                        try {
                            BufferedInputStream bis = new BufferedInputStream(fis);
                            try {
                                int j;
                                while ((j = bis.read()) != -1) {
                                    zos.write(j);
                                }
                            }
                            finally {
                                bis.close();
                            }
                        }
                        finally {
                            fis.close();
                            zos.closeEntry();
                        }
                    }
                }
                finally {
                    zos.close();
                }
            }
            finally {
                bos.close();
            }
        }
        finally {
            fos.close();
        }
    }

    public static String getExtension(File f) {
        String ext = "";
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File addExtensionIfNone(File file, String extension) {
        if (FileUtil.getExtension(file).length() > 0) {
            return file;
        }
        String path = file.getAbsolutePath();
        if (!path.endsWith(".")) {
            path = path + ".";
        }
        path = path + extension;
        return new File(path);
    }
}

