/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.sweepline;

import com.vividsolutions.jts.index.sweepline.SweepLineEvent;
import com.vividsolutions.jts.index.sweepline.SweepLineInterval;
import com.vividsolutions.jts.index.sweepline.SweepLineOverlapAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SweepLineIndex {
    List events = new ArrayList();
    private boolean indexBuilt;
    private int nOverlaps;

    public void add(SweepLineInterval sweepInt) {
        SweepLineEvent insertEvent = new SweepLineEvent(sweepInt.getMin(), null, sweepInt);
        this.events.add(insertEvent);
        this.events.add(new SweepLineEvent(sweepInt.getMax(), insertEvent, sweepInt));
    }

    private void buildIndex() {
        if (this.indexBuilt) {
            return;
        }
        Collections.sort(this.events);
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (!ev.isDelete()) continue;
            ev.getInsertEvent().setDeleteEventIndex(i);
        }
        this.indexBuilt = true;
    }

    public void computeOverlaps(SweepLineOverlapAction action) {
        this.nOverlaps = 0;
        this.buildIndex();
        for (int i = 0; i < this.events.size(); ++i) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (!ev.isInsert()) continue;
            this.processOverlaps(i, ev.getDeleteEventIndex(), ev.getInterval(), action);
        }
    }

    private void processOverlaps(int start, int end, SweepLineInterval s0, SweepLineOverlapAction action) {
        for (int i = start; i < end; ++i) {
            SweepLineEvent ev = (SweepLineEvent)this.events.get(i);
            if (!ev.isInsert()) continue;
            SweepLineInterval s1 = ev.getInterval();
            action.overlap(s0, s1);
            ++this.nOverlaps;
        }
    }
}

