/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.datastore.postgis.PostgisDSConnection;
import com.vividsolutions.jump.parameter.ParameterList;
import com.vividsolutions.jump.parameter.ParameterListSchema;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;

public class PostgisDataStoreDriver
implements DataStoreDriver {
    public static final String DRIVER_NAME = "PostGIS";
    public static final String JDBC_CLASS = "org.postgresql.Driver";
    public static final String URL_PREFIX = "jdbc:postgresql://";
    public static final String PARAM_Server = "Server";
    public static final String PARAM_Port = "Port";
    public static final String PARAM_Instance = "Instance";
    public static final String PARAM_User = "User";
    public static final String PARAM_Password = "Password";
    private static final String[] paramNames = new String[]{"Server", "Port", "Instance", "User", "Password"};
    private static final Class[] paramClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PostgisDataStoreDriver.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = PostgisDataStoreDriver.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = PostgisDataStoreDriver.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PostgisDataStoreDriver.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PostgisDataStoreDriver.class$("java.lang.String")) : class$java$lang$String};
    private final ParameterListSchema schema = new ParameterListSchema(paramNames, paramClasses);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public String getName() {
        return DRIVER_NAME;
    }

    public ParameterListSchema getParameterListSchema() {
        return this.schema;
    }

    public DataStoreConnection createConnection(ParameterList params) throws Exception {
        String host = params.getParameterString(PARAM_Server);
        int port = params.getParameterInt(PARAM_Port);
        String database = params.getParameterString(PARAM_Instance);
        String user = params.getParameterString(PARAM_User);
        String password = params.getParameterString(PARAM_Password);
        String url = String.valueOf(new StringBuffer(URL_PREFIX).append(host).append(":").append(port).append("/").append(database));
        Driver driver = (Driver)Class.forName(JDBC_CLASS).newInstance();
        DriverManager.registerDriver(driver);
        Connection conn = DriverManager.getConnection(url, user, password);
        return new PostgisDSConnection(conn);
    }

    public boolean isAdHocQuerySupported() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

