% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctDataHelp.R
\name{ctExample2}
\alias{ctExample2}
\title{ctExample2}
\format{100 by 18 matrix containing containing ctsem wide format data. 
8 measurement occasions of leisure time and happiness, 
7 measurement occasions of a money intervention dummy,
and 7 measurement intervals for each of 50 individuals.}
\description{
Simulated example dataset for the ctsem package
}
\examples{
\dontrun{
#two process, one time dependent predictor example
Tpoints=20
manifestNames<-c('LeisureTime','Happiness')
TDpredNames<-'MoneyInt'
testm<-ctModel(Tpoints=Tpoints,n.latent=3,n.TDpred=1,n.TIpred=0,n.manifest=2,    
  LAMBDA=cbind(diag(1,2),0),
  MANIFESTVAR=diag(.1,2),
  DRIFT=matrix(c(-.3,.12,0,  -.02,-.3,0, 1,-.3,-.0001  ),nrow=3,ncol=3),
  TRAITVAR=t(chol(matrix(c(.2,-.1,0,  -.1,.21,0,  0,0,0.00001),ncol=3,nrow=3))),
  DIFFUSION=t(chol(diag(c(1.2,.6,0.0001),3))),
  CINT=matrix(c(1,.3,0),nrow=3),
  T0MEANS=matrix(0,ncol=1,nrow=3),
  T0VAR=diag(c(1,1,0),3),
  TDPREDEFFECT=matrix(c(.6,.4,1),nrow=3),
  TDPREDVAR=diag(c(rep(0,Tpoints)),Tpoints),
  TDPREDMEANS=matrix(c(0,0,0,0,0,1,rep(0,Tpoints-6)),ncol=1,nrow=(Tpoints)))
testd<-ctGenerate(testm,n.subjects=10,burnin=10) #generate data

ctIndplot(testd,Tpoints=Tpoints,n.manifest=2,n.subjects=10,colourby="variable")

timestokeep=c(0,1,4,5,7,8,16,19)
deltaT<-timestokeep[-1] - timestokeep[-8]
testd<-testd[,c(paste0('Y',1:2,'_T',rep(timestokeep,each=2)),paste0('TD1_T',timestokeep))]
testd<-cbind(testd,matrix(deltaT,nrow=nrow(testd),ncol=length(deltaT),byrow=TRUE))

colnames(testd)<-ctWideNames(n.manifest=2,Tpoints=8,n.TDpred=1,
manifestNames=manifestNames,TDpredNames=TDpredNames)
ctExample2<-testd
save(ctExample2,file=".\\\\data\\\\ctExample2.rda") 
}
}

