% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimizeClassifier.R
\docType{methods}
\name{minimizeClassifier}
\alias{minimizeClassifier}
\title{Conjugate gradient for a classification network}
\usage{
minimizeClassifier(darch, trainData, targetData,
  cg.length = getParameter(".cg.length"),
  cg.switchLayers = getParameter(".cg.length"),
  dropout = getParameter(".darch.dropout"),
  dropConnect = getParameter(".darch.dropout.dropConnect"),
  matMult = getParameter(".matMult"), debugMode = getParameter(".debug"),
  ...)
}
\arguments{
\item{darch}{A instance of the class \code{\linkS4class{DArch}}.}

\item{trainData}{The training data matrix.}

\item{targetData}{The labels for the training data.}

\item{cg.length}{Numbers of line search}

\item{cg.switchLayers}{Indicates when to train the full network instead of
only the upper two layers}

\item{dropout}{See \code{darch.dropout} parameter of \code{\link{darch}}.}

\item{dropConnect}{See \code{darch.dropout.dropConnect} parameter of
\code{\link{darch}}.}

\item{matMult}{Matrix multiplication function, internal parameter.}

\item{debugMode}{Whether debug mode is enabled, internal parameter.}

\item{...}{Further parameters.}
}
\value{
The trained \code{\linkS4class{DArch}} object.
}
\description{
This function trains a \code{\linkS4class{DArch}} classifier network with the
conjugate gradient method.
}
\details{
This function is build on the basis of the code from G. Hinton et. al.
(http://www.cs.toronto.edu/~hinton/MatlabForSciencePaper.html - last visit 
2016-04-30) for the fine tuning of deep belief nets. The original code is 
located in the files 'backpropclassify.m', 'CG_MNIST.m' and 
'CG_CLASSIFY_INIT.m'. 
It implements the fine tuning for a classification net with backpropagation
using a direct translation of the \code{\link{minimize}} function from C. 
Rassmussen (available at http://www.gatsby.ucl.ac.uk/~edward/code/minimize/ 
- last visit 2016-04-30) to R.
The parameter \code{cg.switchLayers} is for the switch between two training 
type. Like in the original code, the top two layers can be trained alone 
until \code{epoch} is equal to \code{epochSwitch}. Afterwards the entire 
network will be trained.

\code{minimizeClassifier} supports dropout but does not use the weight
update function as defined via the \code{darch.weightUpdateFunction}
parameter of \code{\link{darch}}, so that weight decay, momentum etc. are not
supported.
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris,
 preProc.params = list(method = c("center", "scale")),
 darch.unitFunction = c("sigmoidUnit", "softmaxUnit"),
 darch.fineTuneFunction = "minimizeClassifier",
 cg.length = 3, cg.switchLayers = 5)
}
}
\seealso{
\code{\link{darch}}, \code{\link{fineTuneDArch}}

Other fine-tuning functions: \code{\link{backpropagation}},
  \code{\link{minimizeAutoencoder}},
  \code{\link{rpropagation}}
}

