% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_plot.R, R/util.R
\name{plot.Node}
\alias{plot.Node}
\alias{ToDiagrammeRGraph}
\alias{SetNodeStyle}
\alias{SetEdgeStyle}
\alias{SetGraphStyle}
\alias{GetDefaultTooltip}
\title{Plot a graph, or get a graphviz dot representation of the tree}
\usage{
\method{plot}{Node}(
  x,
  ...,
  direction = c("climb", "descend"),
  pruneFun = NULL,
  output = "graph"
)

ToDiagrammeRGraph(root, direction = c("climb", "descend"), pruneFun = NULL)

SetNodeStyle(node, inherit = TRUE, keepExisting = FALSE, ...)

SetEdgeStyle(node, inherit = TRUE, keepExisting = FALSE, ...)

SetGraphStyle(root, keepExisting = FALSE, ...)

GetDefaultTooltip(node)
}
\arguments{
\item{x}{The root node of the data.tree structure to plot}

\item{...}{For the SetStyle methods, this can be any stlyeName / value pair. See 
http://graphviz.org/Documentation.php for details. For the plot.Node generic method, this is not used.}

\item{direction}{when converting to a network, should the edges point from root to children ("climb") or from child to parent ("descend")?}

\item{pruneFun}{allows providing a prune criteria, i.e. a function taking a \code{Node} as an input, and returning \code{TRUE} or \code{FALSE}. 
If the pruneFun returns FALSE for a Node, then the Node and its entire sub-tree will not be considered.}

\item{output}{A string specifying the output type; \code{graph} (the default)
renders the graph using the \code{\link[DiagrammeR:grViz]{grViz()}} function and \code{visNetwork} renders the
graph using the \code{\link[DiagrammeR:visnetwork]{visnetwork()}} function.}

\item{root}{The root \code{\link{Node}} of the data.tree structure to visualize.}

\item{node}{The \code{\link{Node}} of the data.tree structure on which you would like to set style attributes.}

\item{inherit}{If TRUE, then children will inherit this node's style. 
Otherwise they inherit from this node's parent. Note that the inherit 
always applies to the node, i.e. all style attributes of a node and not 
to a single style attribute.}

\item{keepExisting}{If TRUE, then style attributes are added to possibly
existing style attributes on the node.}
}
\description{
Use these methods to style your graph, and to plot it. The functionality is built around the
DiagrammeR package, so for anything that goes beyond simple plotting, it is recommended to read its 
documentation at http://rich-iannone.github.io/DiagrammeR/docs.html. Note that DiagrammeR is only suggested
by data.tree, so `plot` only works if you have installed it on your system.
}
\details{
Use \code{SetNodeStyle} and \code{SetEdgeStyle} to define the style of your plot. Use \code{plot} to display a 
graphical representation of your tree.

The most common styles that can be set on the nodes are:
\itemize{
  \item{\code{color}}
  \item{\code{fillcolor}}
  \item{\code{fixedsize} true or false}
  \item{\code{fontcolor}}
  \item{\code{fontname}}
  \item{\code{fontsize}}
  \item{\code{height}}
  \item{\code{penwidth}}
  \item{\code{shape} box, ellipse, polygon, circle, box, etc.}
  \item{\code{style}}
  \item{\code{tooltip}}
  \item{\code{width}}
 }
The most common styles that can be set on the edges are:
\itemize{
  \item{\code{arrowhead} e.g. normal, dot, vee}
  \item{\code{arrowsize}}
  \item{\code{arrowtail}}
  \item{\code{color}}
  \item{\code{dir} forward, back, both, none}
  \item{\code{fontcolor}}
  \item{\code{fontname}}
  \item{\code{fontsize}}
  \item{\code{headport}}
  \item{\code{label}}
  \item{\code{minlen}}
  \item{\code{penwidth}}
  \item{\code{tailport}}
  \item{\code{tooltip}}
 }
A good source to understand the attributes is http://graphviz.org/Documentation.php. Another good source
is the DiagrammeR package documentation, or more specifically: http://rich-iannone.github.io/DiagrammeR/docs.html

In addition to the standard GraphViz functionality, the \code{data.tree} plotting infrastructure takes advantage
of the fact that data.tree structure are always hierarchic. Thus, style attributes are inherited from parents
to children on an individual basis. For example, you can set the fontcolor to red on a parent, and then all children
will also have red font, except if you specifically disallow inheritance. Labels and tooltips are never inherited.

Another feature concerns functions: Instead of setting a fixed value (e.g. \code{SetNodeStyle(acme, label = "Acme. Inc"}), 
you can set a function (e.g. \code{SetNodeStyle(acme, label = function(x) x$name)}). The function must take a \code{\link{Node}}
as its single argument. Together with inheritance, this becomes a very powerful tool.
  
The \code{GetDefaultTooltip} method is a utility method that can be used to print all attributes of a \code{\link{Node}}.

There are some more examples in the 'applications' vignette, see \code{vignette('applications', package = "data.tree")}
}
\examples{
data(acme)
SetGraphStyle(acme, rankdir = "TB")
SetEdgeStyle(acme, arrowhead = "vee", color = "blue", penwidth = 2)
#per default, Node style attributes will be inherited:
SetNodeStyle(acme, style = "filled,rounded", shape = "box", fillcolor = "GreenYellow", 
             fontname = "helvetica", tooltip = GetDefaultTooltip)
SetNodeStyle(acme$IT, fillcolor = "LightBlue", penwidth = "5px")
#inheritance can be avoided:
SetNodeStyle(acme$Accounting, inherit = FALSE, fillcolor = "Thistle", 
             fontcolor = "Firebrick", tooltip = "This is the accounting department")
SetEdgeStyle(acme$Research$`New Labs`, 
             color = "red", 
             label = "Focus!", 
             penwidth = 3, 
             fontcolor = "red")
#use Do to set style on specific nodes:
Do(acme$leaves, function(node) SetNodeStyle(node, shape = "egg"))
plot(acme)

#print p as label, where available:
SetNodeStyle(acme, label = function(node) node$p)
plot(acme)

}
