% Generated by roxygen2 (4.0.2): do not edit by hand
\name{readNWISgwl}
\alias{readNWISgwl}
\title{Reads groundwater level measurements from NWISweb.}
\usage{
readNWISgwl(siteNumbers, startDate = "", endDate = "")
}
\arguments{
\item{siteNumbers}{character USGS site number (or multiple sites).  This is usually an 8 digit number}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the earliest possible record.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the latest possible record.}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency_cd \tab character \tab The NWIS code for the agency reporting the data\cr
site_no \tab character \tab The USGS site number \cr
dateTime \tab character \tab The date and time of the value as a character \cr
dateTimeAccuracyCd \tab character \tab Information on the date/time accuracy \cr
censorCode \tab character \tab Censoring information \cr
sourceCode \tab character \tab Information on source of the data \cr
code \tab character \tab Any codes that qualify the corresponding value\cr
value \tab numeric \tab The numeric value for the parameter \cr
}
Note that code and value are repeated for the parameters requested. The names are of the form
X_D_P_S, where X is literal,
D is an option description of the parameter,
P is the parameter code,
and S is the statistic code (if applicable).

There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
siteInfo \tab data.frame \tab A data frame containing information on the requested sites \cr
variableInfo \tab data.frame \tab A data frame containing information on the requested parameters \cr
statisticInfo \tab data.frame \tab A data frame containing information on the requested statistics on the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
}
}
\description{
Reads groundwater level measurements from NWISweb. Mixed date/times come back from the service
depending on the year that the data was collected. See \url{http://waterdata.usgs.gov/usa/nwis/gw}
for details about groundwater. Groundwater dates and times are returned in many different formats, therefore the
date/time information is returned as a character string. Users will need to convert to a date object.
See \url{http://waterservices.usgs.gov/rest/GW-Levels-Service.html} for more information.
}
\examples{
siteNumber <- "434400121275801"
data <- readNWISgwl(siteNumber, '','')
sites <- c("434400121275801", "375907091432201")
data2 <- readNWISgwl(sites, '','')
}
\seealso{
\code{\link{renameNWISColumns}}, \code{\link{importWaterML1}}
}

