% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNode.R
\docType{methods}
\name{updateSystemMetadata}
\alias{updateSystemMetadata}
\alias{updateSystemMetadata,MNode-method}
\title{Update the system metadata associated with an object.}
\usage{
updateSystemMetadata(x, ...)

\S4method{updateSystemMetadata}{MNode}(x, pid, sysmeta)
}
\arguments{
\item{x}{The MNode instance from which the SystemMetadata will be downloaded}

\item{...}{(Not yet used.)}

\item{pid}{The identifier of the object}

\item{sysmeta}{a SystemMetadata instance with updated information.}
}
\value{
A logical value, TRUE if the operation was sucessful, FALSE if there was an error.
}
\description{
A modified SytemMetadata object can be sent to DataONE that contains
updated information. This function allow updating of the system metadata without
updating the object that it describes, so that mutable attribures such as accessPolicy
can be updated easily.
}
\details{
In the version 2.0 library and higher, this operation can utilize an 
'dataone_token' option to provide credentials for write operations in DataONE.
The authentication token is obtained from DataONE (see your profile on https://search.dataone.org).
See the \code{vignette("dataone-overview")} for details.
Alternatively, the version 1.0 approach of using an X.509 certificate in a default location of the file 
system can also be used. This certificate provides authentication credentials from 
CILogon \url{https://cilogon.org/?skin=DataONE}.  See \code{vignette("dataone-overview")} for details.
}
\note{
Please see the vignette *upload-data* for an example: \code{vignette("upload-data")}
}
\seealso{
\url{https://purl.dataone.org/architecture/apis/MN_APIs.html#MNStorage.updateSystemMetadata}
}

