% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R
\name{isAuthorized}
\alias{isAuthorized}
\alias{isAuthorized,D1Node-method}
\title{Check if an action is authorized for the specified identifier}
\usage{
isAuthorized(x, ...)

\S4method{isAuthorized}{D1Node}(x, id, action)
}
\arguments{
\item{x}{The node to send the request to. This is either a \code{"CNode"} or \code{"MNode"} instance.}

\item{...}{(Not yet used)}

\item{id}{The DataONE identifier (pid or sid) to check access for.}

\item{action}{The DataONE action to check, possible values: "read", "write", "changePermission"}
}
\value{
a logical, TRUE if the action is authorized, false if not.
}
\description{
Test if the user identified by the provided token has 
authorization for operation on the specified object.
}
\details{
The identifier parameter may be either a DataONE persistent identifier (pid)
or series identifier (sid).
}
\examples{
\dontrun{
# Send an authorization check to the D1 production CN.
cn <- CNode("PROD")
pid <- "doi:10.6073/pasta/7fcb8fea57843fae65f63094472f502d"
canRead <- isAuthorized(cn, pid, "read")
canWrite <- isAuthorized(cn, pid, "write")
canChange <- isAuthorized(cn, pid, "changePermission")

# Now send a check to a member node.
mn <- getMNode(cn, "urn:node:KNB")
pid <- "doi:10.6085/AA/pisco_recruitment.149.1"
canRead <- isAuthorized(mn, pid, "read")
canWrite <- isAuthorized(mn, pid, "write")
canChange <- isAuthorized(mn, pid, "changePermission")
}
}
\seealso{
\code{\link[=CNode-class]{CNode}}{ class description.}
}
