/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParserTreeConstants;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_Node;

public class SimpleNode
implements RDQL_Node {
    protected RDQL_Node parent;
    protected RDQL_Node[] children;
    protected int id;
    protected RDQLParser parser;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(RDQLParser p, int i) {
        this(i);
        this.parser = p;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(RDQL_Node n) {
        this.parent = n;
    }

    public RDQL_Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(RDQL_Node n, int i) {
        if (this.children == null) {
            this.children = new RDQL_Node[i + 1];
        } else if (i >= this.children.length) {
            RDQL_Node[] c = new RDQL_Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public RDQL_Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return RDQLParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void postParse2(Query query) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                n.postParse2(query);
            }
        }
    }

    public void postParse1(Query query) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                n.postParse1(query);
            }
        }
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }
}

