% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystemMetadata.R
\docType{methods}
\name{parseSystemMetadata}
\alias{parseSystemMetadata}
\alias{parseSystemMetadata,SystemMetadata-method}
\title{Parse an external XML document and populate a SystemMetadata object with the parsed data}
\usage{
parseSystemMetadata(x, ...)

\S4method{parseSystemMetadata}{SystemMetadata}(x, xml, ...)
}
\arguments{
\item{x}{The \code{SystemMetadata} object}

\item{...}{Additional arguments passed to other functions or methods}

\item{xml}{The XML representation of the capabilities, as an XMLInternalElementNode}
}
\value{
the SystemMetadata object representing an object
}
\description{
Parse an XML representation of system metadata, and set the object slots of a SystemMetadata object 
the with obtained values.
}
\examples{
library(XML)
doc <- xmlParseDoc(system.file("testfiles/sysmeta.xml", package="datapack"), asText=FALSE)
sysmeta <- new("SystemMetadata")
sysmeta <- parseSystemMetadata(sysmeta, xmlRoot(doc))
}
\seealso{
\code{\link{SystemMetadata-class}}
}
