% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{RequestFrozenDatetimeModel}
\alias{RequestFrozenDatetimeModel}
\title{Train a new frozen datetime model with parameters from the specified model}
\usage{
RequestFrozenDatetimeModel(
  model,
  trainingRowCount = NULL,
  trainingDuration = NULL,
  trainingStartDate = NULL,
  trainingEndDate = NULL,
  timeWindowSamplePct = NULL
)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{trainingRowCount}{integer. (optional) the number of rows of data that
should be used to train the model.}

\item{trainingDuration}{character. string (optional) a duration string specifying what
time range the data used to train the model should span.}

\item{trainingStartDate}{character. string(optional) the start date of the data to train to model
on ("%Y-%m-%dT%H:%M:%SZ" RFC 3339 format). Only rows occurring at or after this datetime will
be used.}

\item{trainingEndDate}{character. string(optional) the end date of the data to train the model on
("%Y-%m-%dT%H:%M:%SZ" RFC 3339 format). Only rows occurring strictly before this datetime
will be used.}

\item{timeWindowSamplePct}{integer. (optional) May only be specified when the requested model
is a time window (e.g. duration or start and end dates). An integer between 1 and 99
indicating the percentage to sample by within the window. The points kept are determined by
a random uniform sample.}
}
\value{
An integer value that can be used as the modelJobId parameter
  in subsequent calls to the GetDatetimeModelFromJobId function.
}
\description{
Requires that this model belongs to a datetime partitioned project.
 If it does not, an error will occur when submitting the job
}
\details{
Frozen models use the same tuning parameters as their parent model
instead of independently optimizing them to allow efficiently
retraining models on larger amounts of the training data.

In addition to trainingRowCount and trainingDuration, frozen datetime models
may be trained on an exact date range.  Only one of trainingRowCount,
trainingDuration, or trainingStartDate and trainingEndDate should be specified.
Models specified using trainingStartDate and trainingEndDate are the only ones
that can be trained into the holdout data (once the holdout is unlocked).
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetDatetimeModel(modelId)
  RequestFrozenDatetimeModel(model)
}
}
