% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionDatasets.R
\name{ListPredictionDatasets}
\alias{ListPredictionDatasets}
\title{Retrieve all prediction datasets associated with a project}
\usage{
ListPredictionDatasets(project)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}
}
\value{
An S3 object of class 'listDataRobotPredictionDataset', which is a
list of dataframes: each element of the list corresponds to one
prediction dataset associated with the project, and each dataframe has
one row and the following 6 columns:
\describe{
  \item{id}{Character: string giving the unique alphanumeric identifier for the dataset}
  \item{numColumns}{Numeric: number of columns in dataset}
  \item{name}{Character: Name of dataset file}
  \item{created}{Character: Time of upload}
  \item{projectId}{Character: string giving the unique alphanumeric identifier for the project}
  \item{numRows}{Numeric: number of rows in dataset}
}
}
\description{
This function returns an S3 object of class listDataRobotPredictionDataset that
describes all prediction datasets
available for the project specified by the project parameter.
This list may be converted to a dataframe with the as.data.frame
method for objects of class listDataRobotPredictionDataset.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  ListPredictionDatasets(projectId)
}
}
