# Distance Based Measures of Spatial Structures

[![CRAN version](http://www.r-pkg.org/badges/version/dbmss)](https://CRAN.r-project.org/package=dbmss)
[![](http://cranlogs.r-pkg.org/badges/dbmss)](https://CRAN.R-project.org/package=dbmss)
[![Research software impact](http://depsy.org/api/package/cran/dbmss/badge.svg)](http://depsy.org/package/r/dbmss)
[![Build Status](https://travis-ci.org/EricMarcon/dbmss.svg?branch=master)](https://travis-ci.org/EricMarcon/dbmss)
[![codecov](https://codecov.io/github/EricMarcon/dbmss/branch/master/graphs/badge.svg)](https://codecov.io/github/EricMarcon/dbmss) 

dbmss is an R package for simple computation of spatial statistic functions of distance to characterize the spatial structures
of mapped objects, including classical ones (Ripley's *K* and others) and more recent ones used by spatial economists 
(Duranton and Overman's *Kd*, Marcon and Puech's *M*). Relies on spatstat for some core calculation.

# Vignettes

A quick [introduction](https://EricMarcon.github.io/dbmss/) is in `vignette("docs", "dbmss")`.

A full documentation is available in section section of the same vignette (Reference Guide).
It is a continuous update of the paper published in the Journal of Statistical Software ([Marcon et al., 2015](https://www.jstatsoft.org/article/view/v067c03)).

## Reference

Marcon, E., Traissac, S., Puech, F. and Lang, G. (2015). Tools to Characterize Point Patterns: dbmss for R. 
*Journal of Statistical Software*. 67(3): 1-15.
