snowWrapper <-
function(cl, seq, fun, cldata, name="cldata", lib=NULL, evalq=NULL,
size = 1, balancing=c("none", "load", "size", "both"), dir = NULL, 
rng.type=c("none", "RNGstream", "SPRNG"), cleanup=TRUE, ...)
{
    balancing <- match.arg(balancing)
    ## if object name exists in global env, make a copy as tmp, and put back in the end
    if (exists(name, envir=.GlobalEnv)) {
        assign("tmp", get(name, envir=.GlobalEnv))
        on.exit(rm(list=name, envir = .GlobalEnv), add=TRUE)
        on.exit(assign(name, tmp, envir = .GlobalEnv), add=TRUE)
    }
    ## loads lib on each worker
    if (!is.null(lib)) {
        for (i in lib)
            eval(parse(text=paste("clusterEvalQ(cl, library(", i, "))", sep="")))
    }
    ## set seed on each worker
    rng.type <- match.arg(rng.type) 
    if (rng.type != "none") {
        clusterSetupRNG(cl, type = rng.type)
    }
    ## sets common working directory
    if (!is.null(dir)) {
        if (cleanup)
            dirold <- clusterEvalQ(cl, getwd())
        eval(parse(text=paste("clusterEvalQ(cl, setwd('", dir, "'))", sep="")))
    }
    ## evaluates literal expressions if needed
    if (!is.null(evalq)) {
        for (i in evalq)
            eval(parse(text=paste("clusterEvalQ(cl,", i, ")")))
    }
    ## place object name into global env (clusterExport can reach it)
    assign(name, cldata, envir = .GlobalEnv)
    clusterExport(cl, name)
    ## parallel work done here according to balancing
    res <- switch(balancing,
        "none" = parLapply(cl, seq, fun, ...),
        "load" = clusterApplyLB(cl, seq, fun, ...),
        "size" = parLapplySB(cl, seq, size=size, fun, ...),
        "both" = parLapplySLB(cl, seq, size=size, fun, ...))
    if (cleanup) {
        ## remove cldata
        eval(parse(text=paste("clusterEvalQ(cl, rm(", name, "))")))
        ## unload libs
        if (!is.null(lib)) {
            for (i in lib)
                eval(parse(text=paste("clusterEvalQ(cl, detach(package:", i, ", unload=TRUE))", sep="")))
        }
        ## set old dir
        if (!is.null(dir)) {
            dirold <- lapply(dirold, function(z) paste("setwd(\"", z, "\")", sep=""))
            parLapply(cl, dirold, function(z) eval(parse(text=z)))
        }
    }
    res
}
